/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.wildfly;

import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.services.filters.AbstractRequestFilter;

public class WildFlyRequestFilter
extends AbstractRequestFilter
implements Filter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws UnsupportedEncodingException {
        servletRequest.setCharacterEncoding("UTF-8");
        ClientConnection clientConnection = this.createConnection((HttpServletRequest)servletRequest);
        this.filter(clientConnection, session -> {
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private ClientConnection createConnection(final HttpServletRequest request) {
        return new ClientConnection(){

            public String getRemoteAddr() {
                return request.getRemoteAddr();
            }

            public String getRemoteHost() {
                return request.getRemoteHost();
            }

            public int getRemotePort() {
                return request.getRemotePort();
            }

            public String getLocalAddr() {
                return request.getLocalAddr();
            }

            public int getLocalPort() {
                return request.getLocalPort();
            }
        };
    }
}

