/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class BackupForBuilder
extends AbstractConfigurationChildBuilder
implements Builder<BackupForConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes = BackupForConfiguration.attributeDefinitionSet();

    public BackupForBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return BackupForConfiguration.ELEMENT_DEFINITION;
    }

    public BackupForBuilder remoteSite(String siteName) {
        this.attributes.attribute(BackupForConfiguration.REMOTE_SITE).set((Object)siteName);
        return this;
    }

    public BackupForBuilder remoteCache(String name) {
        if (name == null) {
            throw Log.CONFIG.backupForNullCache();
        }
        this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).set((Object)name);
        return this;
    }

    @Deprecated
    public BackupForBuilder defaultRemoteCache() {
        this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).set((Object)"");
        return this;
    }

    public void validate() {
        if (this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).get() == null && this.attributes.attribute(BackupForConfiguration.REMOTE_SITE).get() == null) {
            return;
        }
        if (this.attributes.attribute(BackupForConfiguration.REMOTE_SITE).get() == null || this.attributes.attribute(BackupForConfiguration.REMOTE_CACHE).get() == null) {
            throw Log.CONFIG.backupForMissingParameters();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public BackupForConfiguration create() {
        return new BackupForConfiguration(this.attributes.protect());
    }

    public BackupForBuilder read(BackupForConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "BackupForBuilder [attributes=" + this.attributes + "]";
    }

    public void reset() {
        this.attributes.reset();
    }
}

