/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
extends BaseClusteredReadCommand
implements InitializableCommand,
SegmentSpecificCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private InvocationContextFactory icf;
    private CommandsFactory commandsFactory;
    private AsyncInterceptorChain invoker;
    private InternalEntryFactory entryFactory;
    private boolean isWrite;
    private int segment;

    private ClusteredGetCommand() {
        super(null, 0L);
    }

    public ClusteredGetCommand(ByteString cacheName) {
        super(cacheName, 0L);
    }

    public ClusteredGetCommand(Object key, ByteString cacheName, int segment, long flags) {
        super(cacheName, flags);
        this.key = key;
        this.isWrite = false;
        if (segment < 0) {
            throw new IllegalArgumentException("Segment must 0 or greater!");
        }
        this.segment = segment;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.icf = componentRegistry.getInvocationContextFactory().running();
        this.commandsFactory = componentRegistry.getCommandsFactory();
        this.invoker = componentRegistry.getInterceptorChain().running();
        this.entryFactory = componentRegistry.getInternalEntryFactory().wired();
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        long flagBitSet = EnumUtil.bitSetOf((Enum)Flag.SKIP_REMOTE_LOOKUP);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(this.key, this.segment, EnumUtil.mergeBitSets((long)flagBitSet, (long)this.getFlagsBitSet()));
        command.setTopologyId(this.topologyId);
        InvocationContext invocationContext = this.icf.createRemoteInvocationContextForCommand(command, this.getOrigin());
        CompletableFuture<Object> future = this.invoker.invokeAsync(invocationContext, command);
        return future.thenApply(rv -> {
            if (trace) {
                log.tracef("Return value for key=%s is %s", this.key, rv);
            }
            if (rv instanceof MVCCEntry) {
                MVCCEntry mvccEntry = (MVCCEntry)rv;
                return this.entryFactory.createValue(mvccEntry);
            }
            if (rv instanceof InternalCacheEntry) {
                InternalCacheEntry internalCacheEntry = (InternalCacheEntry)rv;
                return internalCacheEntry.toInternalCacheValue();
            }
            return rv;
        });
    }

    @Deprecated
    public GlobalTransaction getGlobalTransaction() {
        return null;
    }

    @Override
    public byte getCommandId() {
        return 16;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        this.setFlagsBitSet(input.readLong());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", flags=" + this.printFlags() + ", topologyId=" + this.topologyId + "}";
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public void setWrite(boolean write) {
        this.isWrite = write;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }
}

