/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.parsing.Element;

public enum StorageType {
    OBJECT(Element.OBJECT),
    BINARY(Element.BINARY),
    OFF_HEAP(Element.OFF_HEAP);

    private final Element element;
    private static final Map<String, StorageType> STORAGE_PER_ELEMENT;

    private StorageType(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public static StorageType forElement(String element) {
        return STORAGE_PER_ELEMENT.get(element);
    }

    static {
        STORAGE_PER_ELEMENT = new HashMap<String, StorageType>(3);
        for (StorageType storageType : StorageType.values()) {
            STORAGE_PER_ELEMENT.put(storageType.element.getLocalName(), storageType);
        }
    }
}

