/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;

public final class MarshallingObjectOutputStream
extends ObjectOutputStream {
    private Marshaller marshaller;

    protected MarshallingObjectOutputStream(Marshaller marshaller, ByteOutput byteOutput) throws IOException, SecurityException {
        marshaller.start(byteOutput);
        this.marshaller = marshaller;
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.marshaller.writeObject(obj);
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        this.marshaller.writeObjectUnshared(obj);
    }

    @Override
    public void write(int val) throws IOException {
        this.marshaller.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.marshaller.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.marshaller.write(buf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.marshaller.flush();
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.marshaller.writeBoolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.marshaller.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.marshaller.writeShort(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.marshaller.writeChar(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.marshaller.writeInt(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.marshaller.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.marshaller.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.marshaller.writeDouble(val);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.marshaller.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.marshaller.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.marshaller.writeUTF(str);
    }

    @Override
    public final void reset() throws IOException {
        throw new IOException("reset() may not be invoked on this stream");
    }

    @Override
    public final void close() throws IOException {
        this.marshaller.finish();
        this.marshaller = null;
    }

    @Override
    public final void useProtocolVersion(int version) throws IOException {
        throw new IllegalStateException("Protocol version may not be changed");
    }

    @Override
    protected final void annotateClass(Class<?> cl) throws IOException {
        throw new IllegalStateException("Class may not be annotated in this context");
    }

    @Override
    protected final void annotateProxyClass(Class<?> cl) throws IOException {
        throw new IllegalStateException("Class may not be annotated in this context");
    }

    @Override
    protected final Object replaceObject(Object obj) throws IOException {
        throw new IllegalStateException("Object may not be replaced in this context");
    }

    @Override
    protected final boolean enableReplaceObject(boolean enable) throws SecurityException {
        throw new SecurityException("Object replacement may not be controlled in this context");
    }

    @Override
    protected final void writeStreamHeader() throws IOException {
        throw new IllegalStateException("Stream header may not be written in this context");
    }

    @Override
    protected final void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        throw new IllegalStateException("Class descriptor may not be written in this context");
    }

    @Override
    protected final void drain() throws IOException {
        throw new IllegalStateException("Output may not be drained in this context");
    }

    @Override
    public void writeFields() throws IOException {
        throw new IllegalStateException("writeFields may not be called in this context");
    }

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        throw new IllegalStateException("putFields may not be called in this context");
    }

    @Override
    public void defaultWriteObject() throws IOException {
        throw new IllegalStateException("defaultWriteObject may not be called in this context");
    }
}

