/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.fine;

import java.io.NotSerializableException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapPutFunction;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapRemoveFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapPutFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapRemoveFunction;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.cache.session.SessionAttributes;

public class FineSessionAttributes<NK, K, V>
implements SessionAttributes {
    private final NK key;
    private final Map<NK, Map<String, UUID>> namesCache;
    private final Function<UUID, K> keyFactory;
    private final Map<K, V> attributeCache;
    private final Map<K, Optional<Object>> mutations = new ConcurrentHashMap<K, Optional<Object>>();
    private final Marshaller<Object, V> marshaller;
    private final MutatorFactory<K, V> mutatorFactory;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final SessionAttributeActivationNotifier notifier;
    private volatile Map<String, UUID> names;

    public FineSessionAttributes(NK key, Map<String, UUID> names, Map<NK, Map<String, UUID>> namesCache, Function<UUID, K> keyFactory, Map<K, V> attributeCache, Marshaller<Object, V> marshaller, MutatorFactory<K, V> mutatorFactory, Immutability immutability, CacheProperties properties, SessionAttributeActivationNotifier notifier) {
        this.key = key;
        this.setNames(names);
        this.namesCache = namesCache;
        this.keyFactory = keyFactory;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.mutatorFactory = mutatorFactory;
        this.immutability = immutability;
        this.properties = properties;
        this.notifier = notifier;
    }

    public Object removeAttribute(String name) {
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        this.setNames(this.namesCache.compute(this.key, (BiFunction<NK, Map<String, UUID>, Map<String, UUID>>)(this.properties.isTransactional() ? new CopyOnWriteMapRemoveFunction((Object)name) : new ConcurrentMapRemoveFunction((Object)name))));
        K key = this.keyFactory.apply(attributeId);
        Object result = this.read(this.attributeCache.remove(key));
        if (result != null) {
            this.mutations.remove(key);
            if (this.properties.isPersistent()) {
                this.notifier.postActivate(result);
            }
        }
        return result;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshaller.isMarshallable(attribute)) {
            throw new IllegalArgumentException(new NotSerializableException(attribute.getClass().getName()));
        }
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            UUID newAttributeId = FineSessionAttributes.createUUID();
            this.setNames(this.namesCache.compute(this.key, (BiFunction<NK, Map<String, UUID>, Map<String, UUID>>)(this.properties.isTransactional() ? new CopyOnWriteMapPutFunction((Object)name, (Object)newAttributeId) : new ConcurrentMapPutFunction((Object)name, (Object)newAttributeId))));
            attributeId = this.names.get(name);
        }
        K key = this.keyFactory.apply(attributeId);
        Object value = this.marshaller.write(attribute);
        if (this.properties.isPersistent()) {
            this.notifier.prePassivate(attribute);
        }
        Object result = this.read(this.attributeCache.put(key, value));
        if (this.properties.isPersistent()) {
            this.notifier.postActivate(attribute);
            if (result != attribute) {
                this.notifier.postActivate(result);
            }
        }
        if (this.properties.isTransactional()) {
            this.mutations.put(key, Optional.empty());
        } else if (this.immutability.test(attribute)) {
            this.mutations.remove(key);
        } else {
            this.mutations.put(key, Optional.of(attribute));
        }
        return result;
    }

    public Object getAttribute(String name) {
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        K key = this.keyFactory.apply(attributeId);
        Optional<Object> mutableValue = this.mutations.get(key);
        if (mutableValue != null && mutableValue.isPresent()) {
            return mutableValue.get();
        }
        V value = this.attributeCache.get(key);
        Object result = this.read(value);
        if (result != null) {
            if (this.properties.isPersistent()) {
                this.notifier.postActivate(result);
            }
            if (!this.immutability.test(result)) {
                this.mutations.putIfAbsent(key, Optional.of(result));
            }
        }
        return result;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    @Override
    public void close() {
        this.notifier.close();
        for (Map.Entry<K, Optional<Object>> entry : this.mutations.entrySet()) {
            Optional<Object> optional = entry.getValue();
            if (!optional.isPresent()) continue;
            K key = entry.getKey();
            Object value = this.marshaller.write(optional.get());
            this.mutatorFactory.createMutator(key, value).mutate();
        }
        this.mutations.clear();
    }

    private void setNames(Map<String, UUID> names) {
        this.names = names != null ? Collections.unmodifiableMap(names) : Collections.emptyMap();
    }

    private Object read(V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw new IllegalStateException(e);
        }
    }

    private static UUID createUUID() {
        int i;
        byte[] data = new byte[16];
        ThreadLocalRandom.current().nextBytes(data);
        data[6] = (byte)(data[6] & 0xF);
        data[6] = (byte)(data[6] | 0x40);
        data[8] = (byte)(data[8] & 0x3F);
        data[8] = (byte)(data[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

