/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.installation;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.oidc.installation.KeycloakOIDCClientInstallation;
import org.keycloak.protocol.util.ClientCliInstallationUtil;

public class KeycloakOIDCJbossSubsystemClientCliInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri) {
        String deploymentName = "WAR MODULE NAME.war";
        StringBuilder builder = new StringBuilder();
        builder.append("/subsystem=keycloak/secure-deployment=").append(ClientCliInstallationUtil.quote(deploymentName)).append("/:add( \\\n").append("    realm=").append(ClientCliInstallationUtil.quote(realm.getName())).append(", \\\n").append("    resource=").append(ClientCliInstallationUtil.quote(client.getClientId())).append(", \\\n").append("    auth-server-url=").append(baseUri).append(", \\\n");
        if (client.isBearerOnly()) {
            builder.append("    bearer-only=true, \\\n");
        } else if (client.isPublicClient()) {
            builder.append("    public-client=true, \\\n");
        }
        if (KeycloakOIDCClientInstallation.showVerifyTokenAudience(client)) {
            builder.append("    verify-token-audience=true, \\\n");
        }
        if (client.getRoles().size() > 0) {
            builder.append("    use-resource-role-mappings=true, \\\n");
        }
        builder.append("    ssl-required=").append(realm.getSslRequired().name()).append(")\n\n");
        if (KeycloakOIDCClientInstallation.showClientCredentialsAdapterConfig(client)) {
            Map<String, Object> adapterConfig = KeycloakOIDCClientInstallation.getClientCredentialsAdapterConfig(session, client);
            for (Map.Entry<String, Object> entry : adapterConfig.entrySet()) {
                builder.append("/subsystem=keycloak/secure-deployment=").append(ClientCliInstallationUtil.quote(deploymentName)).append("/").append("credential=").append(entry.getKey()).append(":add(value=").append(entry.getValue()).append(")\n");
            }
        }
        return Response.ok((Object)builder.toString(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "openid-connect";
    }

    public String getDisplayType() {
        return "Keycloak OIDC JBoss Subsystem CLI";
    }

    public String getHelpText() {
        return "CLI script you must edit and apply to your client app server. This type of configuration is useful when you can't or don't want to crack open your WAR file.";
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "keycloak-oidc-jboss-subsystem-cli";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public String getFilename() {
        return "keycloak-oidc-subsystem.cli";
    }

    public String getMediaType() {
        return "text/plain";
    }
}

