/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.transaction;

import java.security.AccessController;
import java.util.EnumSet;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.container.ExtendedEntityManager;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.tm.TxUtils;
import org.jboss.tm.listener.EventType;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.AssociationListener;
import org.wildfly.transaction.client.ContextTransactionManager;

public class TransactionUtil {
    private static final EnumSet<EventType> eventTypes = EnumSet.of(EventType.ASSOCIATED, EventType.DISASSOCIATING);

    public static boolean isInTx(TransactionManager transactionManager) {
        Transaction tx = TransactionUtil.getTransaction(transactionManager);
        return tx != null && TxUtils.isActive((Transaction)tx);
    }

    public static EntityManager getTransactionScopedEntityManager(String puScopedName, TransactionSynchronizationRegistry tsr) {
        return TransactionUtil.getEntityManagerInTransactionRegistry(puScopedName, tsr);
    }

    public static void registerSynchronization(EntityManager entityManager, String puScopedName, TransactionSynchronizationRegistry tsr, TransactionManager transactionManager) {
        SessionSynchronization sessionSynchronization = new SessionSynchronization(entityManager, puScopedName);
        tsr.registerInterposedSynchronization((Synchronization)sessionSynchronization);
        AbstractTransaction transaction = ((ContextTransactionManager)transactionManager).getTransaction();
        AccessController.doPrivileged(() -> {
            transaction.registerAssociationListener((AssociationListener)sessionSynchronization);
            return null;
        });
    }

    public static Transaction getTransaction(TransactionManager transactionManager) {
        try {
            return transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw JpaLogger.ROOT_LOGGER.errorGettingTransaction((Exception)((Object)e));
        }
    }

    private static String currentThread() {
        return Thread.currentThread().getName();
    }

    public static String getEntityManagerDetails(EntityManager manager, String scopedPuName) {
        String result = TransactionUtil.currentThread() + ":";
        result = manager instanceof ExtendedEntityManager ? result + manager.toString() : result + "transaction scoped EntityManager [" + scopedPuName + "]";
        return result;
    }

    private static EntityManager getEntityManagerInTransactionRegistry(String scopedPuName, TransactionSynchronizationRegistry tsr) {
        return (EntityManager)tsr.getResource((Object)scopedPuName);
    }

    public static void putEntityManagerInTransactionRegistry(String scopedPuName, EntityManager entityManager, TransactionSynchronizationRegistry tsr) {
        tsr.putResource((Object)scopedPuName, (Object)entityManager);
    }

    private static class SessionSynchronization
    implements Synchronization,
    AssociationListener {
        private EntityManager manager;
        private String scopedPuName;
        private boolean afterCompletionCalled = false;
        private int associationCounter = 1;

        public SessionSynchronization(EntityManager session, String scopedPuName) {
            this.manager = session;
            this.scopedPuName = scopedPuName;
        }

        public void beforeCompletion() {
            this.afterCompletionCalled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            SessionSynchronization sessionSynchronization = this;
            synchronized (sessionSynchronization) {
                this.afterCompletionCalled = true;
                this.safeCloseEntityManager();
            }
        }

        private void safeCloseEntityManager() {
            if (this.afterCompletionCalled && this.associationCounter == 0 && this.manager != null) {
                block4: {
                    try {
                        if (JpaLogger.ROOT_LOGGER.isDebugEnabled()) {
                            JpaLogger.ROOT_LOGGER.debugf("%s: closing entity managersession", TransactionUtil.getEntityManagerDetails(this.manager, this.scopedPuName));
                        }
                        this.manager.close();
                    }
                    catch (Exception ignored) {
                        if (!JpaLogger.ROOT_LOGGER.isDebugEnabled()) break block4;
                        JpaLogger.ROOT_LOGGER.debugf(ignored, "ignoring error that occurred while closing EntityManager for %s (", this.scopedPuName);
                    }
                }
                this.manager = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void associationChanged(AbstractTransaction transaction, boolean associated) {
            SessionSynchronization sessionSynchronization = this;
            synchronized (sessionSynchronization) {
                this.associationCounter += associated ? 1 : -1;
                if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
                    JpaLogger.ROOT_LOGGER.tracef("transaction association counter = %d for %s: ", this.associationCounter, TransactionUtil.getEntityManagerDetails(this.manager, this.scopedPuName));
                }
                this.safeCloseEntityManager();
            }
        }
    }
}

