/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;

public interface Predictable<T> {
    default public OptionalInt size(ImmutableSerializationContext context, T value) {
        return OptionalInt.empty();
    }

    public static int unsignedIntSize(int value) {
        int size = 1;
        for (int i = 7; i < 32; i += 7) {
            if (value < 1 << i) {
                return size;
            }
            ++size;
        }
        return size;
    }

    public static int signedIntSize(int value) {
        int size = 1;
        for (int i = 6; i < 32; i += 7) {
            if (value >= -1 << i && value < 1 << i) {
                return size;
            }
            ++size;
        }
        return size;
    }

    public static int byteArraySize(int value) {
        return Predictable.unsignedIntSize(value) + value;
    }

    public static int stringSize(String value) {
        int length = value.length();
        return Predictable.unsignedIntSize(length) + length;
    }

    public static int unsignedLongSize(long value) {
        int size = 1;
        for (int i = 7; i < 64; i += 7) {
            if (value < 1L << i) {
                return size;
            }
            ++size;
        }
        return size;
    }

    public static int signedLongSize(long value) {
        int size = 1;
        for (int i = 6; i < 64; i += 7) {
            if (value >= -1L << i && value < 1L << i) {
                return size;
            }
            ++size;
        }
        return size;
    }
}

