/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.ResponseProvider;
import io.smallrye.health.SmallRyeHealthReporter;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.health.HealthReporter;
import org.wildfly.extension.microprofile.health.ServerReadinessProbes;

public class HealthReporterService
implements org.jboss.msc.service.Service<HealthReporter> {
    private static HealthReporter healthReporter;
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private String emptyLivenessChecksStatus;
    private String emptyReadinessChecksStatus;
    private LocalModelControllerClient modelControllerClient;

    static void install(OperationContext context, String emptyLivenessChecksStatus, String emptyReadinessChecksStatus) {
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(RuntimeCapability.Builder.of((String)"org.wildfly.microprofile.health.reporter", SmallRyeHealthReporter.class).build());
        Supplier modelControllerClientFactory = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class));
        Supplier managementExecutor = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.executor", Executor.class));
        serviceBuilder.setInstance((Service)new HealthReporterService(modelControllerClientFactory, managementExecutor, emptyLivenessChecksStatus, emptyReadinessChecksStatus)).install();
    }

    private HealthReporterService(Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor, String emptyLivenessChecksStatus, String emptyReadinessChecksStatus) {
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
        this.emptyLivenessChecksStatus = emptyLivenessChecksStatus;
        this.emptyReadinessChecksStatus = emptyReadinessChecksStatus;
    }

    public void start(StartContext context) {
        boolean defaultServerProceduresDisabled = ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.class).orElse(false);
        healthReporter = new HealthReporter(this.emptyLivenessChecksStatus, this.emptyReadinessChecksStatus, defaultServerProceduresDisabled);
        this.modelControllerClient = this.modelControllerClientFactory.get().createSuperUserClient(this.managementExecutor.get(), true);
        if (!defaultServerProceduresDisabled) {
            healthReporter.addServerReadinessCheck(new ServerReadinessProbes.ServerStateCheck(this.modelControllerClient), Thread.currentThread().getContextClassLoader());
            healthReporter.addServerReadinessCheck(new ServerReadinessProbes.NoBootErrorsCheck(this.modelControllerClient), Thread.currentThread().getContextClassLoader());
            healthReporter.addServerReadinessCheck(new ServerReadinessProbes.DeploymentsStatusCheck(this.modelControllerClient), Thread.currentThread().getContextClassLoader());
        }
        HealthCheckResponse.setResponseProvider((HealthCheckResponseProvider)new ResponseProvider());
    }

    public void stop(StopContext context) {
        this.modelControllerClient.close();
        healthReporter = null;
        HealthCheckResponse.setResponseProvider(null);
    }

    public HealthReporter getValue() {
        return healthReporter;
    }
}

