/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.web.WebDeploymentRequirement;

public class RouteRegistryEntryProviderServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<String, Map.Entry<String, Void>> {
    private final SupplierDependency<String> route;

    public RouteRegistryEntryProviderServiceConfigurator(String containerName, String serverName) {
        super(ServiceNameFactory.parseServiceName((String)ClusteringCacheRequirement.REGISTRY_ENTRY.getName()).append(new String[]{containerName, serverName}));
        this.route = new ServiceSupplierDependency(ServiceNameFactory.parseServiceName((String)WebDeploymentRequirement.LOCAL_ROUTE.getName()).append(new String[]{serverName}));
    }

    @Override
    public Map.Entry<String, Void> apply(String route) {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(route, null);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer entry = this.route.register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(entry, (Function)this, this.route);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

