/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.Feature;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public abstract class AbstractCommonConfig
implements CommonConfig {
    private final String configName;
    private final Map<String, Feature> features;
    private final Map<String, String> properties;
    private final List<UnifiedHandlerChainMetaData> preHandlerChains;
    private final List<UnifiedHandlerChainMetaData> postHandlerChains;
    private final Map<String, Object> attachments;

    protected AbstractCommonConfig(String configName, List<UnifiedHandlerChainMetaData> preHandlerChains, List<UnifiedHandlerChainMetaData> postHandlerChains, Map<String, String> properties, Map<String, Feature> features) {
        this.configName = configName;
        this.features = features != null && !features.isEmpty() ? Collections.unmodifiableMap(features) : Collections.emptyMap();
        this.properties = properties != null && !properties.isEmpty() ? Collections.unmodifiableMap(properties) : Collections.emptyMap();
        this.preHandlerChains = preHandlerChains != null && !preHandlerChains.isEmpty() ? Collections.unmodifiableList(preHandlerChains) : Collections.emptyList();
        this.postHandlerChains = postHandlerChains != null && !postHandlerChains.isEmpty() ? Collections.unmodifiableList(postHandlerChains) : Collections.emptyList();
        this.attachments = new HashMap<String, Object>();
    }

    protected AbstractCommonConfig(AbstractCommonConfig base, AbstractCommonConfig addon) {
        List<UnifiedHandlerChainMetaData> list;
        Map<String, Object> map;
        this.configName = base.getConfigName();
        if (addon.features != null && !addon.features.isEmpty()) {
            if (base.features.isEmpty()) {
                map = addon.features;
            } else {
                map = new HashMap<String, Feature>(base.features);
                map.putAll(addon.features);
            }
            this.features = Collections.unmodifiableMap(map);
        } else {
            this.features = Collections.emptyMap();
        }
        if (addon.properties != null && !addon.properties.isEmpty()) {
            if (base.properties.isEmpty()) {
                map = addon.properties;
            } else {
                map = new HashMap<String, String>(base.properties);
                map.putAll(addon.properties);
            }
            this.properties = Collections.unmodifiableMap(map);
        } else {
            this.properties = Collections.emptyMap();
        }
        if (addon.preHandlerChains != null && !addon.preHandlerChains.isEmpty()) {
            if (base.preHandlerChains.isEmpty()) {
                list = addon.preHandlerChains;
            } else {
                list = new ArrayList<UnifiedHandlerChainMetaData>(base.preHandlerChains);
                list.addAll(addon.preHandlerChains);
            }
            this.preHandlerChains = Collections.unmodifiableList(list);
        } else {
            this.preHandlerChains = Collections.emptyList();
        }
        if (addon.postHandlerChains != null && !addon.postHandlerChains.isEmpty()) {
            if (base.postHandlerChains.isEmpty()) {
                list = addon.postHandlerChains;
            } else {
                list = new ArrayList<UnifiedHandlerChainMetaData>(base.postHandlerChains);
                list.addAll(this.preHandlerChains);
            }
            this.postHandlerChains = Collections.unmodifiableList(list);
        } else {
            this.postHandlerChains = Collections.emptyList();
        }
        if (addon.attachments != null && !addon.attachments.isEmpty()) {
            if (base.attachments.isEmpty()) {
                map = addon.attachments;
            } else {
                map = new HashMap<String, Object>(base.attachments);
                map.putAll(addon.attachments);
            }
            this.attachments = new HashMap<String, Object>(map);
        } else {
            this.attachments = new HashMap<String, Object>();
        }
    }

    @Override
    public List<UnifiedHandlerChainMetaData> getPostHandlerChains() {
        return this.postHandlerChains;
    }

    @Override
    public List<UnifiedHandlerChainMetaData> getPreHandlerChains() {
        return this.preHandlerChains;
    }

    @Override
    public List<UnifiedHandlerChainMetaData> getHandlers(UnifiedHandlerMetaData.HandlerType type) {
        List<UnifiedHandlerChainMetaData> handlerChains;
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            handlerChains = this.getPreHandlerChains();
        } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
            handlerChains = this.getPostHandlerChains();
        } else {
            throw Messages.MESSAGES.invalidHandlerType(type != null ? type.toString() : null);
        }
        return handlerChains;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public boolean hasFeature(String name) {
        return this.features.containsKey(name);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getAttachments() {
        return this.attachments;
    }
}

