/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;

public class L1Configuration
implements Matchable<L1Configuration>,
ConfigurationInfo {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).xmlName("").immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> INVALIDATION_THRESHOLD = AttributeDefinition.builder((String)"invalidationThreshold", (Object)0).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Long> LIFESPAN = AttributeDefinition.builder((String)"lifespan", (Object)TimeUnit.MINUTES.toMillis(10L)).xmlName("l1-lifespan").immutable().build();
    public static final AttributeDefinition<Long> CLEANUP_TASK_FREQUENCY = AttributeDefinition.builder((String)"cleanupTaskFrequency", (Object)TimeUnit.MINUTES.toMillis(1L)).xmlName("l1-cleanup-interval").immutable().build();
    static ElementDefinition<L1Configuration> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.L1.getLocalName(), false);
    private final Attribute<Boolean> enabled;
    private final Attribute<Integer> invalidationThreshold;
    private final Attribute<Long> lifespan;
    private final Attribute<Long> cleanupTaskFrequency;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(L1Configuration.class, new AttributeDefinition[]{ENABLED, INVALIDATION_THRESHOLD, LIFESPAN, CLEANUP_TASK_FREQUENCY});
    }

    L1Configuration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.invalidationThreshold = attributes.attribute(INVALIDATION_THRESHOLD);
        this.lifespan = attributes.attribute(LIFESPAN);
        this.cleanupTaskFrequency = attributes.attribute(CLEANUP_TASK_FREQUENCY);
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public int invalidationThreshold() {
        return (Integer)this.invalidationThreshold.get();
    }

    public long cleanupTaskFrequency() {
        return (Long)this.cleanupTaskFrequency.get();
    }

    public long lifespan() {
        return (Long)this.lifespan.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "L1Configuration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        L1Configuration other = (L1Configuration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

