/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation.header;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.LineBreakHandler;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.operation.PropertyListState;
import org.jboss.as.cli.parsing.operation.header.ServerGroupListState;

public class RolloutPlanState
extends DefaultParsingState {
    public static final RolloutPlanState INSTANCE = new RolloutPlanState();
    public static final String ID = "ROLLOUT_PLAN_HEADER";

    RolloutPlanState() {
        this(ServerGroupListState.INSTANCE, new PropertyListState(' ', ' ', ';', '}'));
    }

    RolloutPlanState(final ServerGroupListState sgList, final PropertyListState props) {
        super(ID);
        this.setIgnoreWhitespaces(true);
        this.setEnterHandler(new LineBreakHandler(false, false){

            @Override
            public void doHandle(ParsingContext ctx) throws CommandFormatException {
                int location;
                String input = ctx.getInput();
                if (RolloutPlanState.inputHasArgument("id", input, location = ctx.getLocation()) || RolloutPlanState.inputHasArgument("name", input, location)) {
                    ctx.enterState(props);
                } else {
                    ctx.enterState(sgList);
                }
            }
        });
        this.setDefaultHandler(new EnterStateCharacterHandler(props));
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    return;
                }
                char ch = ctx.getCharacter();
                if (ch == '}' || ch == ';') {
                    ctx.leaveState();
                    return;
                }
                ctx.enterState(props);
            }
        });
    }

    private static boolean inputHasArgument(String argName, String input, int location) {
        return input.startsWith(argName, location) && input.length() > location + argName.length() && (input.charAt(location + argName.length()) == '=' || Character.isWhitespace(input.charAt(location + argName.length())));
    }
}

