/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import io.netty.channel.ChannelPipeline;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.protocol.ServerPacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.ServerSessionPacketHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQPacketHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.BackwardsCompatibilityUtils;
import org.apache.activemq.artemis.core.protocol.core.impl.ChannelImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.Ping;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQFrameDecoder2;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;

public class CoreProtocolManager
implements ProtocolManager<Interceptor> {
    private static final Logger logger = Logger.getLogger(CoreProtocolManager.class);
    private static final List<String> websocketRegistryNames = Collections.EMPTY_LIST;
    protected final ActiveMQServer server;
    private final List<Interceptor> incomingInterceptors;
    private final List<Interceptor> outgoingInterceptors;
    private final CoreProtocolManagerFactory protocolManagerFactory;
    private final Map<SimpleString, RoutingType> prefixes = new HashMap<SimpleString, RoutingType>();
    private final Map<String, ServerSessionPacketHandler> sessionHandlers = new ConcurrentHashMap<String, ServerSessionPacketHandler>();

    public CoreProtocolManager(CoreProtocolManagerFactory factory, ActiveMQServer server, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors) {
        this.protocolManagerFactory = factory;
        this.server = server;
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
    }

    @Override
    public ProtocolManagerFactory<Interceptor> getFactory() {
        return this.protocolManagerFactory;
    }

    @Override
    public void updateInterceptors(List<BaseInterceptor> incoming, List<BaseInterceptor> outgoing) {
        this.incomingInterceptors.clear();
        this.incomingInterceptors.addAll(this.getFactory().filterInterceptors(incoming));
        this.outgoingInterceptors.clear();
        this.outgoingInterceptors.addAll(this.getFactory().filterInterceptors(outgoing));
    }

    @Override
    public boolean acceptsNoHandshake() {
        return false;
    }

    @Override
    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        Configuration config = this.server.getConfiguration();
        ArtemisExecutor connectionExecutor = this.server.getExecutorFactory().getExecutor();
        RemotingConnectionImpl rc = new RemotingConnectionImpl((PacketDecoder)new ServerPacketDecoder(), connection, this.incomingInterceptors, this.outgoingInterceptors, this.server.getNodeID(), (Executor)connectionExecutor);
        Channel channel1 = rc.getChannel(ChannelImpl.CHANNEL_ID.SESSION.id, -1);
        ActiveMQPacketHandler handler = new ActiveMQPacketHandler(this, this.server, channel1, (CoreRemotingConnection)rc);
        channel1.setHandler((ChannelHandler)handler);
        long ttl = ActiveMQClient.DEFAULT_CONNECTION_TTL;
        if (config.getConnectionTTLOverride() != -1L) {
            ttl = config.getConnectionTTLOverride();
        }
        ConnectionEntry entry = new ConnectionEntry((RemotingConnection)rc, (Executor)connectionExecutor, System.currentTimeMillis(), ttl);
        Channel channel0 = rc.getChannel(ChannelImpl.CHANNEL_ID.PING.id, -1);
        channel0.setHandler((ChannelHandler)new LocalChannelHandler(config, entry, channel0, acceptorUsed, (CoreRemotingConnection)rc));
        this.server.getClusterManager().addClusterChannelHandler(rc.getChannel(ChannelImpl.CHANNEL_ID.CLUSTER.id, -1), acceptorUsed, (CoreRemotingConnection)rc, this.server.getActivation());
        return entry;
    }

    ServerSessionPacketHandler getSessionHandler(String sessionName) {
        return this.sessionHandlers.get(sessionName);
    }

    void addSessionHandler(String name, ServerSessionPacketHandler handler) {
        this.sessionHandlers.put(name, handler);
    }

    @Override
    public void removeHandler(String name) {
        this.sessionHandlers.remove(name);
    }

    @Override
    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
    }

    @Override
    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("activemq-decoder", (io.netty.channel.ChannelHandler)new ActiveMQFrameDecoder2());
    }

    @Override
    public boolean isProtocol(byte[] array) {
        return this.isArtemis(ActiveMQBuffers.wrappedBuffer((byte[])array));
    }

    @Override
    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
        if (this.isArtemis(buffer)) {
            buffer.skipBytes(7);
        }
    }

    @Override
    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    @Override
    public void setAnycastPrefix(String anycastPrefix) {
        for (String prefix : anycastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.ANYCAST);
        }
    }

    @Override
    public void setMulticastPrefix(String multicastPrefix) {
        for (String prefix : multicastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.MULTICAST);
        }
    }

    @Override
    public Map<SimpleString, RoutingType> getPrefixes() {
        return this.prefixes;
    }

    private boolean isArtemis(ActiveMQBuffer buffer) {
        return buffer.getByte(0) == 65 && buffer.getByte(1) == 82 && buffer.getByte(2) == 84 && buffer.getByte(3) == 69 && buffer.getByte(4) == 77 && buffer.getByte(5) == 73 && buffer.getByte(6) == 83;
    }

    public String toString() {
        return "CoreProtocolManager(server=" + this.server + ")";
    }

    private class LocalChannelHandler
    implements ChannelHandler {
        private final Configuration config;
        private final ConnectionEntry entry;
        private final Channel channel0;
        private final Acceptor acceptorUsed;
        private final CoreRemotingConnection rc;

        private LocalChannelHandler(Configuration config, ConnectionEntry entry, Channel channel0, Acceptor acceptorUsed, CoreRemotingConnection rc) {
            this.config = config;
            this.entry = entry;
            this.channel0 = channel0;
            this.acceptorUsed = acceptorUsed;
            this.rc = rc;
        }

        public void handlePacket(Packet packet) {
            if (packet.getType() == 10) {
                Ping ping = (Ping)packet;
                if (this.config.getConnectionTTLOverride() == -1L) {
                    this.entry.ttl = ping.getConnectionTTL();
                }
                this.channel0.send(packet);
            } else if (packet.getType() == 112 || packet.getType() == 113) {
                SubscribeClusterTopologyUpdatesMessage msg = (SubscribeClusterTopologyUpdatesMessage)packet;
                if (packet.getType() == 113) {
                    this.channel0.getConnection().setChannelVersion(((SubscribeClusterTopologyUpdatesMessageV2)msg).getClientVersion());
                }
                final ClusterTopologyListener listener = new ClusterTopologyListener(){

                    public void nodeUP(final TopologyMember topologyMember, final boolean last) {
                        try {
                            final Pair connectorPair = BackwardsCompatibilityUtils.checkTCPPairConversion((int)LocalChannelHandler.this.channel0.getConnection().getChannelVersion(), (TopologyMember)topologyMember);
                            final String nodeID = topologyMember.getNodeId();
                            ((LocalChannelHandler)LocalChannelHandler.this).entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (LocalChannelHandler.this.channel0.supports((byte)122)) {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V3(topologyMember.getUniqueEventID(), nodeID, topologyMember.getBackupGroupName(), topologyMember.getScaleDownGroupName(), connectorPair, last));
                                    } else if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V2(topologyMember.getUniqueEventID(), nodeID, topologyMember.getBackupGroupName(), connectorPair, last));
                                    } else {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage(nodeID, connectorPair, last));
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                    }

                    public void nodeDown(final long uniqueEventID, final String nodeID) {
                        try {
                            ((LocalChannelHandler)LocalChannelHandler.this).entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V2(uniqueEventID, nodeID));
                                    } else {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage(nodeID));
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                    }

                    public String toString() {
                        return "Remote Proxy on channel " + Integer.toHexString(System.identityHashCode(this));
                    }
                };
                if (this.acceptorUsed.getClusterConnection() != null) {
                    this.acceptorUsed.getClusterConnection().addClusterTopologyListener(listener);
                    this.rc.addCloseListener(new CloseListener(){

                        public void connectionClosed() {
                            LocalChannelHandler.this.acceptorUsed.getClusterConnection().removeClusterTopologyListener(listener);
                        }
                    });
                } else {
                    this.entry.connectionExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            String nodeId = CoreProtocolManager.this.server.getNodeID().toString();
                            Pair emptyConfig = new Pair(null, null);
                            if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V2(System.currentTimeMillis(), nodeId, null, emptyConfig, true));
                            } else {
                                LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage(nodeId, emptyConfig, true));
                            }
                        }
                    });
                }
            }
        }

        private Pair<TransportConfiguration, TransportConfiguration> getPair(TransportConfiguration conn, boolean isBackup) {
            if (isBackup) {
                return new Pair(null, (Object)conn);
            }
            return new Pair((Object)conn, null);
        }
    }
}

