/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserModelDefaultMethods;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;

public abstract class AbstractUserAdapter
extends UserModelDefaultMethods {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ComponentModel storageProviderModel;
    protected StorageId storageId;
    protected long created = System.currentTimeMillis();

    public AbstractUserAdapter(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
        this.session = session;
        this.realm = realm;
        this.storageProviderModel = storageProviderModel;
    }

    @Override
    public Set<String> getRequiredActions() {
        return Collections.emptySet();
    }

    @Override
    public void addRequiredAction(String action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void removeRequiredAction(String action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    protected Set<GroupModel> getGroupsInternal() {
        return Collections.emptySet();
    }

    protected boolean appendDefaultGroups() {
        return true;
    }

    @Override
    public Set<GroupModel> getGroups() {
        HashSet<GroupModel> set = new HashSet<GroupModel>();
        if (this.appendDefaultGroups()) {
            set.addAll(this.realm.getDefaultGroupsStream().collect(Collectors.toSet()));
        }
        set.addAll(this.getGroupsInternal());
        return set;
    }

    @Override
    public void joinGroup(GroupModel group) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void leaveGroup(GroupModel group) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public boolean isMemberOf(GroupModel group) {
        return RoleUtils.isMember(this.getGroups().stream(), group);
    }

    @Override
    public Set<RoleModel> getRealmRoleMappings() {
        return this.getRoleMappings().stream().filter(RoleUtils::isRealmRole).collect(Collectors.toSet());
    }

    @Override
    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        return this.getRoleMappings().stream().filter(r -> RoleUtils.isClientRole(r, app)).collect(Collectors.toSet());
    }

    @Override
    public boolean hasRole(RoleModel role) {
        return RoleUtils.hasRole(this.getRoleMappings().stream(), role) || RoleUtils.hasRoleFromGroup(this.getGroups().stream(), role, true);
    }

    @Override
    public void grantRole(RoleModel role) {
        throw new ReadOnlyException("user is read only for this update");
    }

    protected boolean appendDefaultRolesToRoleMappings() {
        return true;
    }

    protected Set<RoleModel> getRoleMappingsInternal() {
        return Collections.emptySet();
    }

    @Override
    public Set<RoleModel> getRoleMappings() {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        if (this.appendDefaultRolesToRoleMappings()) {
            set.addAll(DefaultRoles.getDefaultRoles(this.realm).collect(Collectors.toSet()));
        }
        set.addAll(this.getRoleMappingsInternal());
        return set;
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getFederationLink() {
        return null;
    }

    @Override
    public void setFederationLink(String link) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getServiceAccountClientLink() {
        return null;
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getId() {
        if (this.storageId == null) {
            this.storageId = new StorageId(this.storageProviderModel.getId(), this.getUsername());
        }
        return this.storageId.getId();
    }

    @Override
    public void setUsername(String username) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public Long getCreatedTimestamp() {
        return this.created;
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void removeAttribute(String name) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getFirstAttribute(String name) {
        if (name.equals("username")) {
            return this.getUsername();
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap attributes = new MultivaluedHashMap();
        attributes.add((Object)"username", (Object)this.getUsername());
        return attributes;
    }

    @Override
    public List<String> getAttribute(String name) {
        if (name.equals("username")) {
            return Collections.singletonList(this.getUsername());
        }
        return Collections.emptyList();
    }

    @Override
    public String getFirstName() {
        return null;
    }

    @Override
    public void setFirstName(String firstName) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getLastName() {
        return null;
    }

    @Override
    public void setLastName(String lastName) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public String getEmail() {
        return null;
    }

    @Override
    public void setEmail(String email) {
        throw new ReadOnlyException("user is read only for this update");
    }

    @Override
    public boolean isEmailVerified() {
        return false;
    }

    @Override
    public void setEmailVerified(boolean verified) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static abstract class Streams
    extends AbstractUserAdapter
    implements UserModel.Streams {
        public Streams(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
            super(session, realm, storageProviderModel);
        }

        @Override
        public Set<String> getRequiredActions() {
            return this.getRequiredActionsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<String> getRequiredActionsStream() {
            return Stream.empty();
        }

        @Override
        public List<String> getAttribute(String name) {
            return this.getAttributeStream(name).collect(Collectors.toList());
        }

        @Override
        public Stream<String> getAttributeStream(String name) {
            if (name.equals("username")) {
                return Stream.of(this.getUsername());
            }
            return Stream.empty();
        }

        @Override
        public Set<GroupModel> getGroups() {
            return this.getGroupsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<GroupModel> getGroupsStream() {
            Stream<GroupModel> groups = this.getGroupsInternal().stream();
            if (this.appendDefaultGroups()) {
                groups = Stream.concat(groups, this.realm.getDefaultGroupsStream());
            }
            return groups;
        }

        @Override
        public boolean isMemberOf(GroupModel group) {
            return RoleUtils.isMember(this.getGroupsStream(), group);
        }

        @Override
        public Set<RoleModel> getRealmRoleMappings() {
            return this.getRealmRoleMappingsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<RoleModel> getRealmRoleMappingsStream() {
            return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
        }

        @Override
        public Set<RoleModel> getClientRoleMappings(ClientModel app) {
            return this.getClientRoleMappingsStream(app).collect(Collectors.toSet());
        }

        @Override
        public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
            return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole(r, app));
        }

        @Override
        public Set<RoleModel> getRoleMappings() {
            return this.getRoleMappingsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<RoleModel> getRoleMappingsStream() {
            Stream<RoleModel> roleMappings = this.getRoleMappingsInternal().stream();
            if (this.appendDefaultRolesToRoleMappings()) {
                return Stream.concat(roleMappings, DefaultRoles.getDefaultRoles(this.realm));
            }
            return roleMappings;
        }

        @Override
        public boolean hasRole(RoleModel role) {
            return RoleUtils.hasRole(this.getRoleMappingsStream(), role) || RoleUtils.hasRoleFromGroup(this.getGroupsStream(), role, true);
        }
    }
}

