/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.dsl.SimpleQueryStringDefinitionTermination;
import org.hibernate.search.query.dsl.SimpleQueryStringMatchingContext;
import org.hibernate.search.query.dsl.SimpleQueryStringTermination;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsSimpleQueryStringQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;

public class ConnectedSimpleQueryStringMatchingContext
implements SimpleQueryStringMatchingContext {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final List<FieldsContext> fieldsContexts = new ArrayList<FieldsContext>();
    private FieldsContext currentFieldsContext;
    private boolean withAndAsDefaultOperator = false;

    public ConnectedSimpleQueryStringMatchingContext(String field, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.addFields(field);
    }

    public ConnectedSimpleQueryStringMatchingContext(String[] fields, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.addFields(fields);
    }

    @Override
    public SimpleQueryStringMatchingContext andField(String field) {
        this.addFields(field);
        return this;
    }

    @Override
    public SimpleQueryStringMatchingContext andFields(String ... fields) {
        this.addFields(fields);
        return this;
    }

    @Override
    public SimpleQueryStringMatchingContext boostedTo(float boost) {
        this.currentFieldsContext.boostedTo(boost);
        return this;
    }

    @Override
    public SimpleQueryStringTermination matching(String simpleQueryString) {
        return new ConnectedMultiFieldsSimpleQueryStringQueryBuilder(simpleQueryString, this.fieldsContexts, this.withAndAsDefaultOperator, this.queryCustomizer, this.queryContext);
    }

    @Override
    public SimpleQueryStringDefinitionTermination withAndAsDefaultOperator() {
        this.withAndAsDefaultOperator = true;
        return this;
    }

    private void addFields(String ... fields) {
        FieldsContext fieldsContext = new FieldsContext(fields, this.queryContext);
        this.fieldsContexts.add(fieldsContext);
        this.currentFieldsContext = fieldsContext;
    }
}

