/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.OAuthErrorException;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.authorization.AuthorizationTokenService;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.ExchangeExternalToken;
import org.keycloak.broker.provider.ExchangeTokenToIdentityProviderToken;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.provider.IdentityProviderMapperSyncModeDelegate;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenIntrospectionEndpoint;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.TokenRefreshContext;
import org.keycloak.services.clientpolicy.TokenRequestContext;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.util.MtlsHoKTokenUtil;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;
import org.keycloak.utils.ProfileHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TokenEndpoint {
    private static final Logger logger = Logger.getLogger(TokenEndpoint.class);
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private Map<String, String> clientAuthAttributes;
    private static final Pattern VALID_CODE_VERIFIER_PATTERN = Pattern.compile("^[0-9a-zA-Z\\-\\.~_]+$");
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpResponse httpResponse;
    @Context
    private HttpHeaders headers;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private Action action;
    private String grantType;
    private Cors cors;

    public TokenEndpoint(TokenManager tokenManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.realm = realm;
        this.event = event;
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response processGrantRequest() {
        this.cors = Cors.add(this.request).auth().allowedMethods("POST").auth().exposedHeaders("Access-Control-Allow-Methods");
        MultivaluedMap formParameters = this.request.getDecodedFormParameters();
        if (formParameters == null) {
            formParameters = new MultivaluedHashMap();
        }
        this.formParams = formParameters;
        this.grantType = (String)this.formParams.getFirst((Object)"grant_type");
        MultivaluedMap outputHeaders = this.httpResponse.getOutputHeaders();
        outputHeaders.putSingle((Object)"Cache-Control", (Object)"no-store");
        outputHeaders.putSingle((Object)"Pragma", (Object)"no-cache");
        this.checkSsl();
        this.checkRealm();
        this.checkGrantType();
        if (!this.action.equals((Object)Action.PERMISSION)) {
            this.checkClient();
        }
        switch (this.action) {
            case AUTHORIZATION_CODE: {
                return this.codeToToken();
            }
            case REFRESH_TOKEN: {
                return this.refreshTokenGrant();
            }
            case PASSWORD: {
                return this.resourceOwnerPasswordCredentialsGrant();
            }
            case CLIENT_CREDENTIALS: {
                return this.clientCredentialsGrant();
            }
            case TOKEN_EXCHANGE: {
                return this.tokenExchange();
            }
            case PERMISSION: {
                return this.permissionGrant();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    @Path(value="introspect")
    public Object introspect() {
        TokenIntrospectionEndpoint tokenIntrospectionEndpoint = new TokenIntrospectionEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)tokenIntrospectionEndpoint);
        return tokenIntrospectionEndpoint;
    }

    @OPTIONS
    public Response preflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("CORS preflight from: {0}", this.headers.getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().allowedMethods("POST", "OPTIONS").build();
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new CorsErrorResponseException(this.cors.allowAllOrigins(), "access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event);
        this.client = clientAuth.getClient();
        this.clientAuthAttributes = clientAuth.getClientAuthAttributes();
        this.cors.allowedOrigins(this.session, this.client);
        if (this.client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkGrantType() {
        if (this.grantType == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Missing form parameter: grant_type", Response.Status.BAD_REQUEST);
        }
        if (this.grantType.equals("authorization_code")) {
            this.event.event(EventType.CODE_TO_TOKEN);
            this.action = Action.AUTHORIZATION_CODE;
        } else if (this.grantType.equals("refresh_token")) {
            this.event.event(EventType.REFRESH_TOKEN);
            this.action = Action.REFRESH_TOKEN;
        } else if (this.grantType.equals("password")) {
            this.event.event(EventType.LOGIN);
            this.action = Action.PASSWORD;
        } else if (this.grantType.equals("client_credentials")) {
            this.event.event(EventType.CLIENT_LOGIN);
            this.action = Action.CLIENT_CREDENTIALS;
        } else if (this.grantType.equals("urn:ietf:params:oauth:grant-type:token-exchange")) {
            this.event.event(EventType.TOKEN_EXCHANGE);
            this.action = Action.TOKEN_EXCHANGE;
        } else if (this.grantType.equals("urn:ietf:params:oauth:grant-type:uma-ticket")) {
            this.event.event(EventType.PERMISSION_TOKEN);
            this.action = Action.PERMISSION;
        } else {
            throw new CorsErrorResponseException(this.cors, "unsupported_grant_type", "Unsupported grant_type", Response.Status.BAD_REQUEST);
        }
        this.event.detail("grant_type", this.grantType);
    }

    public Response codeToToken() {
        String code = (String)this.formParams.getFirst((Object)"code");
        if (code == null) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Missing parameter: code", Response.Status.BAD_REQUEST);
        }
        OAuth2CodeParser.ParseResult parseResult = OAuth2CodeParser.parseCode(this.session, code, this.realm, this.event);
        if (parseResult.isIllegalCode()) {
            AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
            if (clientSession != null) {
                clientSession.detachFromUserSession();
            }
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code not valid", Response.Status.BAD_REQUEST);
        }
        AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
        if (parseResult.isExpiredCode()) {
            this.event.error("expired_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        UserSessionModel userSession = null;
        if (clientSession != null) {
            userSession = clientSession.getUserSession();
        }
        if (userSession == null) {
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User session not found", Response.Status.BAD_REQUEST);
        }
        UserModel user = userSession.getUser();
        if (user == null) {
            this.event.error("user_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User not found", Response.Status.BAD_REQUEST);
        }
        this.event.user(userSession.getUser());
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        OAuth2Code codeData = parseResult.getCodeData();
        String redirectUri = codeData.getRedirectUriParam();
        String redirectUriParam = (String)this.formParams.getFirst((Object)"redirect_uri");
        if (redirectUriParam != null && redirectUriParam.contains("session_state=") && !redirectUri.contains("session_state=")) {
            redirectUriParam = KeycloakUriBuilder.fromUri((String)redirectUriParam).replaceQueryParam("session_state", null).build(new Object[0]).toString();
        }
        if (redirectUri != null && !redirectUri.equals(redirectUriParam)) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Incorrect redirect_uri", Response.Status.BAD_REQUEST);
        }
        if (!this.client.getClientId().equals(clientSession.getClient().getClientId())) {
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Auth error", Response.Status.BAD_REQUEST);
        }
        if (!this.client.isStandardFlowEnabled()) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Client not allowed to exchange code", Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Session not active", Response.Status.BAD_REQUEST);
        }
        String codeVerifier = (String)this.formParams.getFirst((Object)"code_verifier");
        String codeChallenge = codeData.getCodeChallenge();
        String codeChallengeMethod = codeData.getCodeChallengeMethod();
        String authUserId = user.getId();
        String authUsername = user.getUsername();
        if (authUserId == null) {
            authUserId = "unknown";
        }
        if (authUsername == null) {
            authUsername = "unknown";
        }
        if (codeChallengeMethod != null && !codeChallengeMethod.isEmpty()) {
            this.checkParamsForPkceEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
        } else {
            this.checkParamsForPkceNotEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRequestContext(this.formParams, parseResult));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, "invalid_grant", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        this.updateClientSession(clientSession);
        this.updateUserSessionFromClientAuth(userSession);
        String scopeParam = codeData.getScope();
        Supplier<Stream> clientScopesSupplier = () -> TokenManager.getRequestedClientScopes(scopeParam, this.client);
        if (!TokenManager.verifyConsentStillAvailable(this.session, user, this.client, clientScopesSupplier.get())) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", "Client no longer has requested consent from user", Response.Status.BAD_REQUEST);
        }
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndClientScopes(clientSession, clientScopesSupplier.get(), this.session);
        clientSessionCtx.setAttribute("nonce", codeData.getNonce());
        AccessToken token = this.tokenManager.createClientAccessToken(this.session, this.realm, this.client, user, userSession, clientSessionCtx);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).accessToken(token).generateRefreshToken();
        if (OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseMtlsHokToken()) {
            AccessToken.CertConf certConf = MtlsHoKTokenUtil.bindTokenWithClientCertificate(this.request, this.session);
            if (certConf != null) {
                responseBuilder.getAccessToken().setCertConf(certConf);
                responseBuilder.getRefreshToken().setCertConf(certConf);
            } else {
                this.event.error("invalid_request");
                throw new CorsErrorResponseException(this.cors, "invalid_request", "Client Certification missing for MTLS HoK Token Binding", Response.Status.BAD_REQUEST);
            }
        }
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = null;
        try {
            res = responseBuilder.build();
        }
        catch (RuntimeException re) {
            if ("can not get encryption KEK".equals(re.getMessage())) {
                throw new CorsErrorResponseException(this.cors, "invalid_request", "can not get encryption KEK", Response.Status.BAD_REQUEST);
            }
            throw re;
        }
        this.event.success();
        return this.cors.builder(Response.ok((Object)res).type(MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private void checkParamsForPkceEnforcedClient(String codeVerifier, String codeChallenge, String codeChallengeMethod, String authUserId, String authUsername) {
        if (codeVerifier == null) {
            logger.warnf("PKCE code verifier not specified, authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
            this.event.error("code_verifier_missing");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE code verifier not specified", Response.Status.BAD_REQUEST);
        }
        this.verifyCodeVerifier(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
    }

    private void checkParamsForPkceNotEnforcedClient(String codeVerifier, String codeChallenge, String codeChallengeMethod, String authUserId, String authUsername) {
        if (codeChallenge != null && codeVerifier == null) {
            logger.warnf("PKCE code verifier not specified, authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
            this.event.error("code_verifier_missing");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE code verifier not specified", Response.Status.BAD_REQUEST);
        }
        if (codeChallenge != null) {
            this.verifyCodeVerifier(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername);
        }
    }

    private void verifyCodeVerifier(String codeVerifier, String codeChallenge, String codeChallengeMethod, String authUserId, String authUsername) {
        if (!this.isValidPkceCodeVerifier(codeVerifier)) {
            logger.infof("PKCE invalid code verifier", new Object[0]);
            this.event.error("invalid_code_verifier");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE invalid code verifier", Response.Status.BAD_REQUEST);
        }
        logger.debugf("PKCE supporting Client, codeVerifier = %s", (Object)codeVerifier);
        String codeVerifierEncoded = codeVerifier;
        try {
            if (codeChallengeMethod != null && codeChallengeMethod.equals("S256")) {
                logger.debugf("PKCE codeChallengeMethod = %s", (Object)codeChallengeMethod);
                codeVerifierEncoded = this.generateS256CodeChallenge(codeVerifier);
            } else {
                logger.debug((Object)"PKCE codeChallengeMethod is plain");
                codeVerifierEncoded = codeVerifier;
            }
        }
        catch (Exception nae) {
            logger.infof("PKCE code verification failed, not supported algorithm specified", new Object[0]);
            this.event.error("pkce_verification_failed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE code verification failed, not supported algorithm specified", Response.Status.BAD_REQUEST);
        }
        if (!codeChallenge.equals(codeVerifierEncoded)) {
            logger.warnf("PKCE verification failed. authUserId = %s, authUsername = %s", (Object)authUserId, (Object)authUsername);
            this.event.error("pkce_verification_failed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "PKCE verification failed", Response.Status.BAD_REQUEST);
        }
        logger.debugf("PKCE verification success. codeVerifierEncoded = %s, codeChallenge = %s", (Object)codeVerifierEncoded, (Object)codeChallenge);
    }

    public Response refreshTokenGrant() {
        AccessTokenResponse res;
        String refreshToken = (String)this.formParams.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRefreshContext(this.formParams));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, "invalid_grant", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        try {
            TokenManager.RefreshResult result = this.tokenManager.refreshAccessToken(this.session, (UriInfo)this.session.getContext().getUri(), this.clientConnection, this.realm, this.client, refreshToken, this.event, this.headers, this.request);
            res = result.getResponse();
            if (!result.isOfflineToken()) {
                UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, res.getSessionState());
                AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(this.client.getId());
                this.updateClientSession(clientSession);
                this.updateUserSessionFromClientAuth(userSession);
            }
        }
        catch (OAuthErrorException e) {
            logger.trace((Object)e.getMessage(), (Throwable)e);
            if ("Client certificate missing, or its thumbprint and one in the refresh token did NOT match".equals(e.getDescription())) {
                this.event.error("not_allowed");
                throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.UNAUTHORIZED);
            }
            this.event.error("invalid_token");
            throw new CorsErrorResponseException(this.cors, e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private void updateClientSession(AuthenticatedClientSessionModel clientSession) {
        if (clientSession == null) {
            ServicesLogger.LOGGER.clientSessionNull();
            return;
        }
        String adapterSessionId = (String)this.formParams.getFirst((Object)"client_session_state");
        if (adapterSessionId != null) {
            String oldClientSessionHost;
            String adapterSessionHost = (String)this.formParams.getFirst((Object)"client_session_host");
            logger.debugf("Adapter Session '%s' saved in ClientSession for client '%s'. Host is '%s'", (Object)adapterSessionId, (Object)this.client.getClientId(), (Object)adapterSessionHost);
            String oldClientSessionState = clientSession.getNote("client_session_state");
            if (!adapterSessionId.equals(oldClientSessionState)) {
                clientSession.setNote("client_session_state", adapterSessionId);
            }
            if (!Objects.equals(adapterSessionHost, oldClientSessionHost = clientSession.getNote("client_session_host"))) {
                clientSession.setNote("client_session_host", adapterSessionHost);
            }
        }
    }

    private void updateUserSessionFromClientAuth(UserSessionModel userSession) {
        for (Map.Entry<String, String> attr : this.clientAuthAttributes.entrySet()) {
            userSession.setNote(attr.getKey(), attr.getValue());
        }
    }

    public Response resourceOwnerPasswordCredentialsGrant() {
        this.event.detail("auth_method", "oauth_credentials");
        if (!this.client.isDirectAccessGrantsEnabled()) {
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Client not allowed for direct access grants", Response.Status.BAD_REQUEST);
        }
        if (this.client.isConsentRequired()) {
            this.event.error("consent_denied");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
        }
        String scope = this.getRequestedScopes();
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setProtocol("openid-connect");
        authSession.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        AuthenticationFlowModel flow = AuthenticationFlowResolver.resolveDirectGrantFlow((AuthenticationSessionModel)authSession);
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowId(flowId).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri()).setRequest(this.request);
        Response challenge = processor.authenticateOnly();
        if (challenge != null) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, false);
            this.cors.build(this.httpResponse);
            return challenge;
        }
        processor.evaluateRequiredActionTriggers();
        UserModel user = authSession.getAuthenticatedUser();
        if (user.getRequiredActionsStream().count() > 0L) {
            new AuthenticationSessionManager(this.session).removeAuthenticationSession(this.realm, authSession, false);
            this.event.error("resolve_required_actions");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Account is not fully set up", Response.Status.BAD_REQUEST);
        }
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext clientSessionCtx = processor.attachSession();
        UserSessionModel userSession = processor.getUserSession();
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).generateAccessToken().generateRefreshToken();
        String scopeParam = clientSessionCtx.getClientSession().getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        AuthenticationManager.logSuccess(this.session, authSession);
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    public Response clientCredentialsGrant() {
        if (this.client.isBearerOnly()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Bearer-only client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (this.client.isPublicClient()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Public client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (!this.client.isServiceAccountsEnabled()) {
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Client not enabled to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        UserModel clientUser = this.session.users().getServiceAccount(this.client);
        if (clientUser == null || this.client.getProtocolMapperByName("openid-connect", "Client ID") == null) {
            logger.debugf("Service account user for client '%s' not found or default protocol mapper for service account not found. Creating now", (Object)this.client.getClientId());
            new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
            clientUser = this.session.users().getServiceAccount(this.client);
        }
        String clientUsername = clientUser.getUsername();
        this.event.detail("username", clientUsername);
        this.event.user(clientUser);
        if (!clientUser.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "User '" + clientUsername + "' disabled", Response.Status.UNAUTHORIZED);
        }
        String scope = this.getRequestedScopes();
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setAuthenticatedUser(clientUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        UserSessionModel.SessionPersistenceState sessionPersistenceState = UserSessionModel.SessionPersistenceState.PERSISTENT;
        boolean useRefreshToken = OIDCAdvancedConfigWrapper.fromClientModel(this.client).isUseRefreshTokenForClientCredentialsGrant();
        if (!useRefreshToken) {
            sessionPersistenceState = UserSessionModel.SessionPersistenceState.TRANSIENT;
        }
        UserSessionModel userSession = this.session.sessions().createUserSession(authSession.getParentSession().getId(), this.realm, clientUser, clientUsername, this.clientConnection.getRemoteAddr(), "client_auth", false, null, null, sessionPersistenceState);
        this.event.session(userSession);
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteAddr());
        this.updateUserSessionFromClientAuth(userSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).generateAccessToken();
        if (useRefreshToken) {
            responseBuilder = responseBuilder.generateRefreshToken();
        } else {
            responseBuilder.getAccessToken().setSessionState(null);
        }
        String scopeParam = clientSessionCtx.getClientSession().getNote("scope");
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    private String getRequestedScopes() {
        String scope = (String)this.formParams.getFirst((Object)"scope");
        if (!TokenManager.isValidScope(scope, this.client)) {
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", "Invalid scopes: " + scope, Response.Status.BAD_REQUEST);
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response tokenExchange() {
        String requestedIssuer;
        String requestedSubject;
        ProfileHelper.requireFeature(Profile.Feature.TOKEN_EXCHANGE);
        this.event.detail("auth_method", "token_exchange");
        this.event.client(this.client);
        UserModel tokenUser = null;
        UserSessionModel tokenSession = null;
        AccessToken token = null;
        String subjectToken = (String)this.formParams.getFirst((Object)"subject_token");
        if (subjectToken != null) {
            String subjectTokenType = (String)this.formParams.getFirst((Object)"subject_token_type");
            String realmIssuerUrl = Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName());
            String subjectIssuer = (String)this.formParams.getFirst((Object)"subject_issuer");
            if (subjectIssuer == null && "urn:ietf:params:oauth:token-type:jwt".equals(subjectTokenType)) {
                try {
                    JWSInput jws = new JWSInput(subjectToken);
                    JsonWebToken jwt = (JsonWebToken)jws.readJsonContent(JsonWebToken.class);
                    subjectIssuer = jwt.getIssuer();
                }
                catch (JWSInputException e) {
                    this.event.detail("reason", "unable to parse jwt subject_token");
                    this.event.error("invalid_token");
                    throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
                }
            }
            if (subjectIssuer != null && !realmIssuerUrl.equals(subjectIssuer)) {
                this.event.detail("subject_issuer", subjectIssuer);
                return this.exchangeExternalToken(subjectIssuer, subjectToken);
            }
            if (subjectTokenType != null && !subjectTokenType.equals("urn:ietf:params:oauth:token-type:access_token")) {
                this.event.detail("reason", "subject_token supports access tokens only");
                this.event.error("invalid_token");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
            }
            AuthenticationManager.AuthResult authResult = AuthenticationManager.verifyIdentityToken(this.session, this.realm, (UriInfo)this.session.getContext().getUri(), this.clientConnection, true, true, null, false, subjectToken, this.headers, new TokenVerifier.Predicate[0]);
            if (authResult == null) {
                this.event.detail("reason", "subject_token validation failure");
                this.event.error("invalid_token");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid token", Response.Status.BAD_REQUEST);
            }
            tokenUser = authResult.getUser();
            tokenSession = authResult.getSession();
            token = authResult.getToken();
        }
        if ((requestedSubject = (String)this.formParams.getFirst((Object)"requested_subject")) != null) {
            this.event.detail("requested_subject", requestedSubject);
            UserModel requestedUser = this.session.users().getUserByUsername(requestedSubject, this.realm);
            if (requestedUser == null) {
                requestedUser = this.session.users().getUserById(requestedSubject, this.realm);
            }
            if (requestedUser == null) {
                this.event.detail("reason", "requested_subject not found");
                this.event.error("not_allowed");
                throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
            }
            if (token != null) {
                this.event.detail("impersonator", tokenUser.getUsername());
                AdminAuth auth = new AdminAuth(this.realm, token, tokenUser, this.client);
                if (!AdminPermissions.evaluator(this.session, this.realm, auth).users().canImpersonate(requestedUser)) {
                    this.event.detail("reason", "subject not allowed to impersonate");
                    this.event.error("not_allowed");
                    throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
            } else {
                if (this.client.isPublicClient()) {
                    this.event.detail("reason", "public clients not allowed");
                    this.event.error("not_allowed");
                    throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
                if (!AdminPermissions.management(this.session, this.realm).users().canClientImpersonate(this.client, requestedUser)) {
                    this.event.detail("reason", "client not allowed to impersonate");
                    this.event.error("not_allowed");
                    throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
            }
            tokenSession = this.session.sessions().createUserSession(this.realm, requestedUser, requestedUser.getUsername(), this.clientConnection.getRemoteAddr(), "impersonate", false, null, null);
            if (tokenUser != null) {
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_ID.toString(), tokenUser.getId());
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString(), tokenUser.getUsername());
            }
            tokenUser = requestedUser;
        }
        if ((requestedIssuer = (String)this.formParams.getFirst((Object)"requested_issuer")) == null) {
            return this.exchangeClientToClient(tokenUser, tokenSession);
        }
        try {
            Response response = this.exchangeToIdentityProvider(tokenUser, tokenSession, requestedIssuer);
            return response;
        }
        finally {
            if (subjectToken == null) {
                try {
                    this.session.sessions().removeUserSession(this.realm, tokenSession);
                }
                catch (Exception exception) {}
            }
        }
    }

    public Response exchangeToIdentityProvider(UserModel targetUser, UserSessionModel targetUserSession, String requestedIssuer) {
        this.event.detail("requested_issuer", requestedIssuer);
        IdentityProviderModel providerModel = this.realm.getIdentityProviderByAlias(requestedIssuer);
        if (providerModel == null) {
            this.event.detail("reason", "unknown requested_issuer");
            this.event.error("unknown_identity_provider");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Invalid issuer", Response.Status.BAD_REQUEST);
        }
        IdentityProvider provider = IdentityBrokerService.getIdentityProvider(this.session, this.realm, requestedIssuer);
        if (!(provider instanceof ExchangeTokenToIdentityProviderToken)) {
            this.event.detail("reason", "exchange unsupported by requested_issuer");
            this.event.error("unknown_identity_provider");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Issuer does not support token exchange", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).idps().canExchangeTo(this.client, providerModel)) {
            this.event.detail("reason", "client not allowed to exchange for requested_issuer");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        Response response = ((ExchangeTokenToIdentityProviderToken)provider).exchangeFromToken((UriInfo)this.session.getContext().getUri(), this.event, this.client, targetUserSession, targetUser, this.formParams);
        return this.cors.builder(Response.fromResponse((Response)response)).build();
    }

    protected Response exchangeClientToClient(UserModel targetUser, UserSessionModel targetUserSession) {
        String requestedTokenType = (String)this.formParams.getFirst((Object)"requested_token_type");
        if (requestedTokenType == null) {
            requestedTokenType = "urn:ietf:params:oauth:token-type:refresh_token";
        } else if (!(requestedTokenType.equals("urn:ietf:params:oauth:token-type:access_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token") || requestedTokenType.equals("urn:ietf:params:oauth:token-type:saml2"))) {
            this.event.detail("reason", "requested_token_type unsupported");
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
        }
        ClientModel targetClient = this.client;
        String audience = (String)this.formParams.getFirst((Object)"audience");
        if (audience != null && (targetClient = this.realm.getClientByClientId(audience)) == null) {
            this.event.detail("reason", "audience not found");
            this.event.error("client_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Audience not found", Response.Status.BAD_REQUEST);
        }
        if (targetClient.isConsentRequired()) {
            this.event.detail("reason", "audience requires consent");
            this.event.error("consent_denied");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
        }
        if (!targetClient.equals(this.client) && !AdminPermissions.management(this.session, this.realm).clients().canExchangeTo(this.client, targetClient)) {
            this.event.detail("reason", "client not allowed to exchange to audience");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        switch (requestedTokenType) {
            case "urn:ietf:params:oauth:token-type:access_token": 
            case "urn:ietf:params:oauth:token-type:refresh_token": {
                return this.exchangeClientToOIDCClient(targetUser, targetUserSession, requestedTokenType, targetClient, audience, scope);
            }
            case "urn:ietf:params:oauth:token-type:saml2": {
                return this.exchangeClientToSAML2Client(targetUser, targetUserSession, requestedTokenType, targetClient, audience, scope);
            }
        }
        throw new CorsErrorResponseException(this.cors, "invalid_request", "requested_token_type unsupported", Response.Status.BAD_REQUEST);
    }

    protected Response exchangeClientToOIDCClient(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, ClientModel targetClient, String audience, String scope) {
        String scopeParam;
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(targetClient);
        authSession.setAuthenticatedUser(targetUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        this.event.session(targetUserSession);
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, targetUserSession, authSession);
        this.updateUserSessionFromClientAuth(targetUserSession);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, targetClient, this.event, this.session, targetUserSession, clientSessionCtx).generateAccessToken();
        responseBuilder.getAccessToken().issuedFor(this.client.getClientId());
        if (audience != null) {
            responseBuilder.getAccessToken().addAudience(audience);
        }
        if (requestedTokenType.equals("urn:ietf:params:oauth:token-type:refresh_token")) {
            responseBuilder.generateRefreshToken();
            responseBuilder.getRefreshToken().issuedFor(this.client.getClientId());
        }
        if (TokenUtil.isOIDCRequest((String)(scopeParam = clientSessionCtx.getClientSession().getNote("scope")))) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        AccessTokenResponse res = responseBuilder.build();
        this.event.detail("audience", targetClient.getClientId());
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    protected Response exchangeClientToSAML2Client(UserModel targetUser, UserSessionModel targetUserSession, String requestedTokenType, ClientModel targetClient, String audience, String scope) {
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "saml");
        SamlService samlService = (SamlService)factory.createProtocolEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)samlService);
        AuthenticationSessionModel authSession = samlService.getOrCreateLoginSessionForIdpInitiatedSso(this.session, this.realm, targetClient, null);
        if (authSession == null) {
            logger.error((Object)"SAML assertion consumer url not set up");
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Client requires assertion consumer url set up", Response.Status.BAD_REQUEST);
        }
        authSession.setAuthenticatedUser(targetUser);
        this.event.session(targetUserSession);
        AuthenticationManager.setClientScopesInSession(authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, targetUserSession, authSession);
        this.updateUserSessionFromClientAuth(targetUserSession);
        SamlClient samlClient = new SamlClient(targetClient);
        SamlProtocol samlProtocol = new TokenExchangeSamlProtocol(samlClient).setEventBuilder(this.event).setHttpHeaders(this.headers).setRealm(this.realm).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri());
        Response samlAssertion = samlProtocol.authenticated(authSession, targetUserSession, clientSessionCtx);
        if (samlAssertion.getStatus() != 200) {
            throw new CorsErrorResponseException(this.cors, "invalid_request", "Can not get SAML 2.0 token", Response.Status.BAD_REQUEST);
        }
        String xmlString = (String)samlAssertion.getEntity();
        String encodedXML = Base64Url.encode((byte[])xmlString.getBytes(GeneralConstants.SAML_CHARSET));
        int assertionLifespan = samlClient.getAssertionLifespan();
        AccessTokenResponse res = new AccessTokenResponse();
        res.setToken(encodedXML);
        res.setTokenType("Bearer");
        res.setExpiresIn(assertionLifespan <= 0 ? (long)this.realm.getAccessCodeLifespan() : (long)assertionLifespan);
        res.setOtherClaims("issued_token_type", (Object)requestedTokenType);
        this.event.detail("audience", targetClient.getClientId());
        this.event.success();
        return this.cors.builder(Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).build();
    }

    public Response exchangeExternalToken(String issuer, String subjectToken) {
        AtomicReference<Object> externalIdp = new AtomicReference<Object>(null);
        AtomicReference<Object> externalIdpModel = new AtomicReference<Object>(null);
        this.realm.getIdentityProvidersStream().filter(idpModel -> {
            IdentityProviderFactory factory = IdentityBrokerService.getIdentityProviderFactory(this.session, idpModel);
            IdentityProvider idp = factory.create(this.session, idpModel);
            if (idp instanceof ExchangeExternalToken) {
                ExchangeExternalToken external = (ExchangeExternalToken)idp;
                if (idpModel.getAlias().equals(issuer) || external.isIssuer(issuer, this.formParams)) {
                    externalIdp.set(external);
                    externalIdpModel.set(idpModel);
                    return true;
                }
            }
            return false;
        }).findFirst();
        if (externalIdp.get() == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        if (!AdminPermissions.management(this.session, this.realm).idps().canExchangeTo(this.client, externalIdpModel.get())) {
            this.event.detail("reason", "client not allowed to exchange subject_issuer");
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
        }
        BrokeredIdentityContext context = ((ExchangeExternalToken)externalIdp.get()).exchangeExternal(this.event, this.formParams);
        if (context == null) {
            this.event.error("invalid_issuer");
            throw new CorsErrorResponseException(this.cors, "invalid_issuer", "Invalid subject_issuer parameter", Response.Status.BAD_REQUEST);
        }
        UserModel user = this.importUserFromExternalIdentity(context);
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realm, user, user.getUsername(), this.clientConnection.getRemoteAddr(), "external-exchange", false, null, null);
        ((ExchangeExternalToken)externalIdp.get()).exchangeExternalComplete(userSession, context, this.formParams);
        userSession.setNote("EXTERNAL_IDENTITY_PROVIDER", ((IdentityProviderModel)externalIdpModel.get()).getAlias());
        userSession.setNote("FEDERATED_ACCESS_TOKEN", subjectToken);
        return this.exchangeClientToClient(user, userSession);
    }

    protected UserModel importUserFromExternalIdentity(BrokeredIdentityContext context) {
        IdentityProviderModel identityProviderConfig = context.getIdpConfig();
        String providerId = identityProviderConfig.getAlias();
        context.getIdp().preprocessFederatedIdentity(this.session, this.realm, context);
        Set mappers = this.realm.getIdentityProviderMappersByAliasStream(context.getIdpConfig().getAlias()).collect(Collectors.toSet());
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        for (IdentityProviderMapperModel mapper : mappers) {
            IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
            target.preprocessFederatedIdentity(this.session, this.realm, mapper, context);
        }
        FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(providerId, context.getId(), context.getUsername(), context.getToken());
        UserModel user = this.session.users().getUserByFederatedIdentity(federatedIdentityModel, this.realm);
        if (user == null) {
            UserModel existingUser;
            logger.debugf("Federated user not found for provider '%s' and broker username '%s'.", (Object)providerId, (Object)context.getUsername());
            String username = context.getModelUsername();
            if (username == null) {
                username = this.realm.isRegistrationEmailAsUsername() && !Validation.isBlank(context.getEmail()) ? context.getEmail() : (context.getUsername() == null ? context.getIdpConfig().getAlias() + "." + context.getId() : context.getUsername());
            }
            username = username.trim();
            context.setModelUsername(username);
            if (context.getEmail() != null && !this.realm.isDuplicateEmailsAllowed() && (existingUser = this.session.users().getUserByEmail(context.getEmail(), this.realm)) != null) {
                this.event.error("federated_identity_account_exists");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "User already exists", Response.Status.BAD_REQUEST);
            }
            existingUser = this.session.users().getUserByUsername(username, this.realm);
            if (existingUser != null) {
                this.event.error("federated_identity_account_exists");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "User already exists", Response.Status.BAD_REQUEST);
            }
            user = this.session.users().addUser(this.realm, username);
            user.setEnabled(true);
            user.setEmail(context.getEmail());
            user.setFirstName(context.getFirstName());
            user.setLastName(context.getLastName());
            federatedIdentityModel = new FederatedIdentityModel(context.getIdpConfig().getAlias(), context.getId(), context.getUsername(), context.getToken());
            this.session.users().addFederatedIdentity(this.realm, user, federatedIdentityModel);
            context.getIdp().importNewUser(this.session, this.realm, user, context);
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.importNewUser(this.session, this.realm, user, mapper, context);
            }
            if (context.getIdpConfig().isTrustEmail() && !Validation.isBlank(user.getEmail())) {
                logger.debugf("Email verified automatically after registration of user '%s' through Identity provider '%s' ", (Object)user.getUsername(), (Object)context.getIdpConfig().getAlias());
                user.setEmailVerified(true);
            }
        } else {
            if (!user.isEnabled()) {
                this.event.error("user_disabled");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid Token", Response.Status.BAD_REQUEST);
            }
            if (this.realm.isBruteForceProtected() && ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, user)) {
                this.event.error("user_temporarily_disabled");
                throw new CorsErrorResponseException(this.cors, "invalid_token", "Invalid Token", Response.Status.BAD_REQUEST);
            }
            context.getIdp().updateBrokeredUser(this.session, this.realm, user, context);
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                IdentityProviderMapperSyncModeDelegate.delegateUpdateBrokeredUser((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user, (IdentityProviderMapperModel)mapper, (BrokeredIdentityContext)context, (IdentityProviderMapper)target);
            }
        }
        return user;
    }

    public Response permissionGrant() {
        String responsePermissionsLimit;
        this.event.detail("auth_method", "oauth_credentials");
        String accessTokenString = null;
        String authorizationHeader = (String)this.headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authorizationHeader != null && authorizationHeader.toLowerCase().startsWith("bearer")) {
            new AppAuthManager();
            accessTokenString = AppAuthManager.extractAuthorizationHeaderToken(this.headers);
        }
        if (accessTokenString != null) {
            AccessToken accessToken = Tokens.getAccessToken(this.session);
            if (accessToken == null) {
                try {
                    AccessToken invalidToken = (AccessToken)new JWSInput(accessTokenString).readJsonContent(AccessToken.class);
                    ClientModel client = this.realm.getClientByClientId(invalidToken.getIssuedFor());
                    this.cors.allowedOrigins(this.session, client);
                }
                catch (JWSInputException invalidToken) {
                    // empty catch block
                }
                throw new CorsErrorResponseException(this.cors, "invalid_grant", "Invalid bearer token", Response.Status.UNAUTHORIZED);
            }
            ClientModel client = this.realm.getClientByClientId(accessToken.getIssuedFor());
            this.session.getContext().setClient(client);
            this.cors.allowedOrigins(this.session, client);
        }
        String claimToken = null;
        if (this.formParams.containsKey((Object)"claim_token")) {
            claimToken = (String)((List)this.formParams.get((Object)"claim_token")).get(0);
        }
        String claimTokenFormat = (String)this.formParams.getFirst((Object)"claim_token_format");
        if (claimToken != null && claimTokenFormat == null) {
            claimTokenFormat = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken";
        }
        String subjectToken = (String)this.formParams.getFirst((Object)"subject_token");
        if (accessTokenString == null) {
            this.checkClient();
            accessTokenString = "http://openid.net/specs/openid-connect-core-1_0.html#IDToken".equalsIgnoreCase(claimTokenFormat) ? claimToken : (subjectToken != null ? subjectToken : ((AccessTokenResponse)AccessTokenResponse.class.cast(this.clientCredentialsGrant().getEntity())).getToken());
        }
        AuthorizationTokenService.KeycloakAuthorizationRequest authorizationRequest = new AuthorizationTokenService.KeycloakAuthorizationRequest((AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class), this.tokenManager, this.event, this.request, this.cors, this.clientConnection);
        authorizationRequest.setTicket((String)this.formParams.getFirst((Object)"ticket"));
        authorizationRequest.setClaimToken(claimToken);
        authorizationRequest.setClaimTokenFormat(claimTokenFormat);
        authorizationRequest.setPct((String)this.formParams.getFirst((Object)"pct"));
        String rpt = (String)this.formParams.getFirst((Object)"rpt");
        if (rpt != null) {
            AccessToken accessToken = (AccessToken)this.session.tokens().decode(rpt, AccessToken.class);
            if (accessToken == null) {
                throw new CorsErrorResponseException(this.cors, "invalid_rpt", "RPT signature is invalid", Response.Status.FORBIDDEN);
            }
            authorizationRequest.setRpt(accessToken);
        }
        authorizationRequest.setScope((String)this.formParams.getFirst((Object)"scope"));
        authorizationRequest.setAudience((String)this.formParams.getFirst((Object)"audience"));
        authorizationRequest.setSubjectToken(accessTokenString);
        String submitRequest = (String)this.formParams.getFirst((Object)"submit_request");
        authorizationRequest.setSubmitRequest(submitRequest == null ? true : Boolean.valueOf(submitRequest));
        List permissions = (List)this.formParams.get((Object)"permission");
        if (permissions != null) {
            for (String permission : permissions) {
                String[] parts = permission.split("#");
                String resource = parts[0];
                if (parts.length == 1) {
                    authorizationRequest.addPermission(resource, new String[0]);
                    continue;
                }
                String[] scopes = parts[1].split(",");
                authorizationRequest.addPermission(parts[0], scopes);
            }
        }
        AuthorizationRequest.Metadata metadata = new AuthorizationRequest.Metadata();
        String responseIncludeResourceName = (String)this.formParams.getFirst((Object)"response_include_resource_name");
        if (responseIncludeResourceName != null) {
            metadata.setIncludeResourceName(Boolean.valueOf(Boolean.parseBoolean(responseIncludeResourceName)));
        }
        if ((responsePermissionsLimit = (String)this.formParams.getFirst((Object)"response_permissions_limit")) != null) {
            metadata.setLimit(Integer.valueOf(Integer.parseInt(responsePermissionsLimit)));
        }
        metadata.setResponseMode((String)this.formParams.getFirst((Object)"response_mode"));
        authorizationRequest.setMetadata(metadata);
        return AuthorizationTokenService.instance().authorize(authorizationRequest);
    }

    private boolean isValidPkceCodeVerifier(String codeVerifier) {
        if (codeVerifier.length() < 43) {
            logger.infof(" Error: PKCE codeVerifier length under lower limit , codeVerifier = %s", (Object)codeVerifier);
            return false;
        }
        if (codeVerifier.length() > 128) {
            logger.infof(" Error: PKCE codeVerifier length over upper limit , codeVerifier = %s", (Object)codeVerifier);
            return false;
        }
        Matcher m = VALID_CODE_VERIFIER_PATTERN.matcher(codeVerifier);
        return m.matches();
    }

    private String generateS256CodeChallenge(String codeVerifier) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(codeVerifier.getBytes("ISO_8859_1"));
        byte[] digestBytes = md.digest();
        String codeVerifierEncoded = Base64Url.encode((byte[])digestBytes);
        return codeVerifierEncoded;
    }

    private static class TokenExchangeSamlProtocol
    extends SamlProtocol {
        final SamlClient samlClient;

        TokenExchangeSamlProtocol(SamlClient samlClient) {
            this.samlClient = samlClient;
        }

        @Override
        protected Response buildAuthenticatedResponse(AuthenticatedClientSessionModel clientSession, String redirectUri, Document samlDocument, JaxrsSAML2BindingBuilder bindingBuilder) throws ConfigurationException, ProcessingException, IOException {
            JaxrsSAML2BindingBuilder.PostBindingBuilder builder = bindingBuilder.postBinding(samlDocument);
            Element assertionElement = this.samlClient.requiresEncryption() ? DocumentUtil.getElement((Document)builder.getDocument(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ENCRYPTED_ASSERTION.get())) : DocumentUtil.getElement((Document)builder.getDocument(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()));
            if (assertionElement == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String assertion = DocumentUtil.getNodeAsString((Node)assertionElement);
            return Response.ok((Object)assertion, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }

        @Override
        protected Response buildErrorResponse(boolean isPostBinding, String destination, JaxrsSAML2BindingBuilder binding, Document document) throws ConfigurationException, ProcessingException, IOException {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    private static enum Action {
        AUTHORIZATION_CODE,
        REFRESH_TOKEN,
        PASSWORD,
        CLIENT_CREDENTIALS,
        TOKEN_EXCHANGE,
        PERMISSION;

    }
}

