/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.ReferenceCounter;

public class ReferenceCounterUtil
implements ReferenceCounter {
    private Runnable task;
    private final Executor executor;
    private final AtomicInteger uses = new AtomicInteger(0);

    public ReferenceCounterUtil() {
        this.executor = null;
        this.task = null;
    }

    public ReferenceCounterUtil(Executor executor) {
        this.executor = executor;
    }

    public ReferenceCounterUtil(Runnable runnable, Executor executor) {
        this.setTask(runnable);
        this.executor = executor;
    }

    public ReferenceCounterUtil(Runnable runnable) {
        this.setTask(runnable);
        this.executor = null;
    }

    @Override
    public void setTask(Runnable task) {
        this.task = task;
    }

    @Override
    public Runnable getTask() {
        return this.task;
    }

    @Override
    public int increment() {
        return this.uses.incrementAndGet();
    }

    @Override
    public int decrement() {
        int value = this.uses.decrementAndGet();
        if (value == 0) {
            this.execute();
        }
        return value;
    }

    private void execute() {
        if (this.executor != null) {
            this.executor.execute(this.task);
        } else {
            this.task.run();
        }
    }

    @Override
    public void check() {
        if (this.getCount() <= 0) {
            this.execute();
        }
    }

    @Override
    public int getCount() {
        return this.uses.get();
    }
}

