/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.context.ExternalContextImpl;
import com.sun.faces.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestCookieMap
extends BaseContextMap<Object> {
    private final HttpServletRequest request;

    public RequestCookieMap(HttpServletRequest newRequest) {
        this.request = newRequest;
    }

    @Override
    public Object get(Object key) {
        Util.notNull("key", key);
        Cookie[] cookies = this.request.getCookies();
        if (null == cookies) {
            return null;
        }
        String keyString = key.toString();
        Cookie result = null;
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(keyString)) continue;
            result = cookies[i];
            break;
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ExternalContextImpl.theUnmodifiableMapClass && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * this.request.hashCode();
        Iterator<Map.Entry<String, Object>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += ((Object)i.next()).hashCode();
        }
        return hashCode;
    }

    @Override
    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this, new CookieArrayEnumerator(this.request.getCookies()));
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this, new CookieArrayEnumerator(this.request.getCookies()));
    }

    @Override
    protected Iterator<Object> getValueIterator() {
        return new BaseContextMap.ValueIterator(this, new CookieArrayEnumerator(this.request.getCookies()));
    }

    private static class CookieArrayEnumerator
    implements Enumeration {
        Cookie[] cookies;
        int curIndex = -1;
        int upperBound;

        public CookieArrayEnumerator(Cookie[] cookies) {
            this.cookies = cookies;
            this.upperBound = this.cookies != null ? this.cookies.length : -1;
        }

        @Override
        public boolean hasMoreElements() {
            return this.curIndex + 2 <= this.upperBound;
        }

        public Object nextElement() {
            ++this.curIndex;
            if (this.curIndex < this.upperBound) {
                return this.cookies[this.curIndex].getName();
            }
            throw new NoSuchElementException();
        }
    }
}

