/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.io.OutputStream;
import java.security.AccessController;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.ElytronMessages;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.impl.BaseHttpServerRequest;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class HttpAuthenticator {
    private static final String MY_AUTHENTICATED_IDENTITY_KEY = HttpAuthenticator.class.getName() + ".authenticated-identity";
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final Supplier<IdentityCache> identityCacheSupplier;
    private final SecurityDomain securityDomain;
    private final HttpExchangeSpi httpExchangeSpi;
    private final boolean required;
    private final boolean ignoreOptionalFailures;
    private final String programmaticMechanismName;
    private final Consumer<Runnable> logoutHandlerConsumer;
    private volatile IdentityCache identityCache;
    private volatile boolean authenticated = false;

    private HttpAuthenticator(Builder builder) {
        this.mechanismSupplier = builder.mechanismSupplier;
        this.securityDomain = builder.securityDomain;
        this.programmaticMechanismName = builder.programmaticMechanismName;
        this.logoutHandlerConsumer = builder.logoutHandlerConsumer;
        this.httpExchangeSpi = builder.httpExchangeSpi;
        this.required = builder.required;
        this.ignoreOptionalFailures = builder.ignoreOptionalFailures;
        this.identityCacheSupplier = builder.identityCacheSupplier != null ? builder.identityCacheSupplier : () -> this.createIdentityCache(this.programmaticMechanismName);
    }

    public boolean authenticate() throws HttpAuthenticationException {
        if (this.restoreIdentity()) {
            return true;
        }
        return new AuthenticationExchange().authenticate();
    }

    private boolean isAuthenticated() {
        return this.authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityIdentity login(String username, String password) {
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(((String)Assert.checkNotNullParam((String)"password", (Object)password)).toCharArray());
        try {
            SecurityIdentity securityIdentity = this.login(username, (Evidence)evidence, this.programmaticMechanismName);
            return securityIdentity;
        }
        finally {
            evidence.destroy();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityIdentity login(String username, Evidence evidence, String mechanismName) {
        if (this.securityDomain == null) {
            return null;
        }
        try (ServerAuthenticationContext authenticationContext = this.createServerAuthenticationContext();){
            authenticationContext.setAuthenticationName(username);
            if (authenticationContext.verifyEvidence(evidence)) {
                if (evidence instanceof PasswordGuessEvidence) {
                    ElytronMessages.log.tracef("Associating credential for '%s' with identity.", username);
                    authenticationContext.addPrivateCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])((PasswordGuessEvidence)evidence).getGuess())));
                }
                if (authenticationContext.authorize()) {
                    SecurityIdentity authorizedIdentity = authenticationContext.getAuthorizedIdentity();
                    IdentityCache identityCache = this.getOrCreateIdentityCache();
                    identityCache.put(authorizedIdentity);
                    this.logoutHandlerConsumer.accept(() -> ((IdentityCache)identityCache).remove());
                    this.httpExchangeSpi.authenticationComplete(authorizedIdentity, mechanismName);
                    SecurityIdentity securityIdentity = authorizedIdentity;
                    return securityIdentity;
                }
                this.httpExchangeSpi.authenticationFailed("Authorization Failed", mechanismName);
                return null;
            }
            this.httpExchangeSpi.authenticationFailed("Authentication Failed", mechanismName);
            return null;
        }
        catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
            this.httpExchangeSpi.authenticationFailed(e.getMessage(), mechanismName);
        }
        return null;
    }

    private ServerAuthenticationContext createServerAuthenticationContext() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> this.securityDomain.createNewAuthenticationContext());
        }
        return this.securityDomain.createNewAuthenticationContext();
    }

    private boolean restoreIdentity() {
        if (this.securityDomain == null) {
            return false;
        }
        IdentityCache identityCache = this.getOrCreateIdentityCache();
        CachedIdentity cachedIdentity = identityCache.get();
        if (cachedIdentity != null) {
            ServerAuthenticationContext authenticationContext = this.securityDomain.createNewAuthenticationContext();
            SecurityIdentity securityIdentity = cachedIdentity.getSecurityIdentity();
            try {
                boolean authorized = securityIdentity != null && authenticationContext.importIdentity(securityIdentity);
                boolean cache = false;
                if (!authorized) {
                    ElytronMessages.log.trace("Unable to use SecurityIdentity from CachedIdentity - attempting to recreate");
                    authenticationContext.setAuthenticationName(cachedIdentity.getName());
                    authorized = authenticationContext.authorize();
                    cache = true;
                }
                if (authorized) {
                    securityIdentity = authenticationContext.getAuthorizedIdentity();
                    this.httpExchangeSpi.authenticationComplete(securityIdentity, cachedIdentity.getMechanismName());
                    this.logoutHandlerConsumer.accept(() -> ((IdentityCache)identityCache).remove());
                    if (cache) {
                        ElytronMessages.log.tracef("Replacing cached identity for '%s' against session scope.", cachedIdentity.getName());
                        identityCache.put(securityIdentity);
                    }
                    return true;
                }
            }
            catch (IllegalArgumentException | IllegalStateException | RealmUnavailableException e) {
                this.httpExchangeSpi.authenticationFailed(e.getMessage(), this.programmaticMechanismName);
            }
            ElytronMessages.log.tracef("Restoring identity '%s' failed, clearing cache from scope.", cachedIdentity.getName());
            identityCache.remove();
        } else {
            ElytronMessages.log.trace("No CachedIdentity to restore.");
        }
        return false;
    }

    private IdentityCache getOrCreateIdentityCache() {
        if (this.identityCache == null) {
            this.identityCache = this.identityCacheSupplier.get();
        }
        return this.identityCache;
    }

    private IdentityCache createIdentityCache(final String mechanismName) {
        return new IdentityCache(){

            public void put(SecurityIdentity identity) {
                HttpScope session = HttpAuthenticator.this.getAttachableSessionScope(true);
                if (session == null || !session.exists()) {
                    if (ElytronMessages.log.isTraceEnabled()) {
                        ElytronMessages.log.tracef("Unable to cache identity for '%s'.", identity.getPrincipal().getName());
                    }
                    return;
                }
                if (session.supportsChangeID() && session.getAttachment(MY_AUTHENTICATED_IDENTITY_KEY) == null) {
                    session.changeID();
                }
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.tracef("Caching identity for '%s' against session scope.", identity.getPrincipal().getName());
                }
                session.setAttachment(MY_AUTHENTICATED_IDENTITY_KEY, new CachedIdentity(mechanismName, true, identity));
            }

            public CachedIdentity get() {
                HttpScope session = HttpAuthenticator.this.getAttachableSessionScope(false);
                if (session == null || !session.exists()) {
                    return null;
                }
                return (CachedIdentity)session.getAttachment(MY_AUTHENTICATED_IDENTITY_KEY);
            }

            public CachedIdentity remove() {
                HttpScope session = HttpAuthenticator.this.getAttachableSessionScope(false);
                if (session == null || !session.exists()) {
                    return null;
                }
                CachedIdentity cachedIdentity = this.get();
                session.setAttachment(MY_AUTHENTICATED_IDENTITY_KEY, null);
                return cachedIdentity;
            }
        };
    }

    private HttpScope getAttachableSessionScope(boolean createSession) {
        HttpScope scope = this.httpExchangeSpi.getScope(Scope.SESSION);
        if (scope == null || !scope.supportsAttachments()) {
            return null;
        }
        if (scope != null && !scope.exists() && createSession) {
            scope.create();
        }
        return scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        private SecurityDomain securityDomain;
        private HttpExchangeSpi httpExchangeSpi;
        private boolean required;
        private boolean ignoreOptionalFailures;
        private Consumer<Runnable> logoutHandlerConsumer;
        private String programmaticMechanismName;
        private Supplier<IdentityCache> identityCacheSupplier;

        Builder() {
        }

        public Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        public Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder setHttpExchangeSpi(HttpExchangeSpi httpExchangeSpi) {
            this.httpExchangeSpi = httpExchangeSpi;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setIgnoreOptionalFailures(boolean ignoreOptionalFailures) {
            this.ignoreOptionalFailures = ignoreOptionalFailures;
            return this;
        }

        public Builder registerLogoutHandler(Consumer<Runnable> logoutHandlerConsumer) {
            this.logoutHandlerConsumer = (Consumer)Assert.checkNotNullParam((String)"logoutHandlerConsumer", logoutHandlerConsumer);
            return this;
        }

        public Builder setProgrammaticMechanismName(String programmaticMechanismName) {
            this.programmaticMechanismName = programmaticMechanismName;
            return this;
        }

        public Builder setIdentityCacheSupplier(Supplier<IdentityCache> identityCacheSupplier) {
            this.identityCacheSupplier = identityCacheSupplier;
            return this;
        }

        public HttpAuthenticator build() {
            return new HttpAuthenticator(this);
        }
    }

    private class AuthenticationExchange
    extends BaseHttpServerRequest
    implements HttpServerRequest,
    HttpServerResponse {
        private volatile HttpServerAuthenticationMechanism currentMechanism;
        private volatile boolean authenticationAttempted;
        private volatile int statusCode;
        private volatile boolean statusCodeAllowed;
        private volatile List<HttpServerMechanismsResponder> responders;
        private volatile HttpServerMechanismsResponder successResponder;

        AuthenticationExchange() {
            super(HttpAuthenticator.this.httpExchangeSpi);
            this.authenticationAttempted = false;
            this.statusCode = -1;
            this.statusCodeAllowed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean authenticate() throws HttpAuthenticationException {
            List authenticationMechanisms = (List)HttpAuthenticator.this.mechanismSupplier.get();
            if (HttpAuthenticator.this.required && authenticationMechanisms.size() == 0) {
                throw ElytronMessages.log.httpAuthenticationNoMechanisms();
            }
            this.responders = new ArrayList<HttpServerMechanismsResponder>(authenticationMechanisms.size());
            boolean evaluationFailed = false;
            try {
                Iterator iterator = authenticationMechanisms.iterator();
                while (iterator.hasNext()) {
                    HttpServerAuthenticationMechanism nextMechanism;
                    this.currentMechanism = nextMechanism = (HttpServerAuthenticationMechanism)iterator.next();
                    try {
                        nextMechanism.evaluateRequest(this);
                    }
                    catch (HttpAuthenticationException e) {
                        evaluationFailed = true;
                        ElytronMessages.log.trace("Request evaluation for mechanism '%s' failed.", nextMechanism.getMechanismName(), e);
                    }
                    if (!HttpAuthenticator.this.isAuthenticated()) continue;
                    if (this.successResponder != null) {
                        this.statusCodeAllowed = true;
                        this.successResponder.sendResponse(this);
                        if (this.statusCode > 0) {
                            HttpAuthenticator.this.httpExchangeSpi.setStatusCode(this.statusCode);
                            boolean e = false;
                            return e;
                        }
                    }
                    boolean e = true;
                    return e;
                }
                this.currentMechanism = null;
                if (HttpAuthenticator.this.required || this.authenticationAttempted && !HttpAuthenticator.this.ignoreOptionalFailures) {
                    this.statusCodeAllowed = true;
                    if (this.responders.size() > 0) {
                        boolean atLeastOneChallenge = false;
                        int defaultStatusCode = 200;
                        boolean statusSet = false;
                        for (HttpServerMechanismsResponder responder : this.responders) {
                            try {
                                responder.sendResponse(this);
                                atLeastOneChallenge = true;
                                if (statusSet || this.statusCode <= 0) continue;
                                if (this.statusCode == 403) {
                                    defaultStatusCode = this.statusCode;
                                    continue;
                                }
                                if (this.statusCode == 200) continue;
                                statusSet = true;
                                HttpAuthenticator.this.httpExchangeSpi.setStatusCode(this.statusCode);
                            }
                            catch (HttpAuthenticationException e) {
                                ElytronMessages.log.trace("HTTP Authentication mechanism unable to send challenge.", e);
                            }
                        }
                        if (!atLeastOneChallenge) {
                            throw ElytronMessages.log.httpAuthenticationNoSuccessfulResponder();
                        }
                        if (!statusSet) {
                            HttpAuthenticator.this.httpExchangeSpi.setStatusCode(defaultStatusCode);
                        }
                    } else {
                        if (evaluationFailed) {
                            throw ElytronMessages.log.httpAuthenticationFailedEvaluatingRequest();
                        }
                        HttpAuthenticator.this.httpExchangeSpi.setStatusCode(403);
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                for (HttpServerAuthenticationMechanism current : authenticationMechanisms) {
                    current.dispose();
                }
            }
        }

        @Override
        public Certificate[] getPeerCertificates() {
            return HttpAuthenticator.this.httpExchangeSpi.getPeerCertificates(HttpAuthenticator.this.required);
        }

        @Override
        public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationInProgress(HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void authenticationComplete(HttpServerMechanismsResponder responder) {
            HttpAuthenticator.this.authenticated = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationComplete(this.currentMechanism.getNegotiationProperty("wildfly.http.security-identity", SecurityIdentity.class), this.currentMechanism.getMechanismName());
            this.successResponder = responder;
        }

        @Override
        public void authenticationComplete(HttpServerMechanismsResponder responder, Runnable logoutHandler) {
            this.authenticationComplete(responder);
            if (HttpAuthenticator.this.logoutHandlerConsumer != null) {
                HttpAuthenticator.this.logoutHandlerConsumer.accept(logoutHandler);
            }
        }

        @Override
        public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationFailed(message, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void badRequest(HttpAuthenticationException failure, HttpServerMechanismsResponder responder) {
            this.authenticationAttempted = true;
            HttpAuthenticator.this.httpExchangeSpi.badRequest(failure, this.currentMechanism.getMechanismName());
            if (responder != null) {
                this.responders.add(responder);
            }
        }

        @Override
        public void addResponseHeader(String headerName, String headerValue) {
            HttpAuthenticator.this.httpExchangeSpi.addResponseHeader(headerName, headerValue);
        }

        @Override
        public void setStatusCode(int statusCode) {
            if (!this.statusCodeAllowed) {
                throw ElytronMessages.log.statusCodeNotNow();
            }
            if (this.statusCode < 0 || statusCode != 200) {
                this.statusCode = statusCode;
            }
        }

        @Override
        public OutputStream getOutputStream() {
            return HttpAuthenticator.this.httpExchangeSpi.getResponseOutputStream();
        }

        @Override
        public void setResponseCookie(HttpServerCookie cookie) {
            HttpAuthenticator.this.httpExchangeSpi.setResponseCookie(cookie);
        }

        @Override
        public boolean forward(String path) {
            int statusCode = HttpAuthenticator.this.httpExchangeSpi.forward(path);
            if (statusCode > 0) {
                this.setStatusCode(statusCode);
                return true;
            }
            return false;
        }

        @Override
        public boolean suspendRequest() {
            return HttpAuthenticator.this.httpExchangeSpi.suspendRequest();
        }

        @Override
        public boolean resumeRequest() {
            return HttpAuthenticator.this.httpExchangeSpi.resumeRequest();
        }
    }
}

