/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.security.cert.X509Certificate;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.authentication.authenticators.x509.AbstractX509ClientCertificateDirectGrantAuthenticator;
import org.keycloak.authentication.authenticators.x509.CertificateValidator;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;

public class ValidateX509CertificateUsername
extends AbstractX509ClientCertificateDirectGrantAuthenticator {
    protected static ServicesLogger logger = ServicesLogger.LOGGER;

    public void authenticate(AuthenticationFlowContext context) {
        UserModel user;
        X509Certificate[] certs = this.getCertificateChain(context);
        if (certs == null || certs.length == 0) {
            logger.debug("[ValidateX509CertificateUsername:authenticate] x509 client certificate is not available for mutual SSL.");
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_request", "X509 client certificate is missing.");
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        this.saveX509CertificateAuditDataToAuthSession(context, certs[0]);
        this.recordX509CertificateAuditDataViaContextEvent(context);
        X509AuthenticatorConfigModel config = null;
        if (context.getAuthenticatorConfig() != null && context.getAuthenticatorConfig().getConfig() != null) {
            config = new X509AuthenticatorConfigModel(context.getAuthenticatorConfig());
        }
        if (config == null) {
            logger.warn("[ValidateX509CertificateUsername:authenticate] x509 Client Certificate Authentication configuration is not available.");
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_request", "Configuration is missing.");
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        try {
            CertificateValidator.CertificateValidatorBuilder builder = this.certificateValidationParameters(context.getSession(), config);
            CertificateValidator validator = builder.build(certs);
            validator.checkRevocationStatus().validateKeyUsage().validateExtendedKeyUsage().validateTimestamps();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_request", e.getMessage());
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        Object userIdentity = this.getUserIdentityExtractor(config).extractUserIdentity(certs);
        if (userIdentity == null) {
            context.getEvent().error("invalid_user_credentials");
            logger.errorf("[ValidateX509CertificateUsername:authenticate] Unable to extract user identity from certificate.", new Object[0]);
            String errorMessage = "Unable to extract user identity from specified certificate";
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_request", errorMessage);
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        try {
            context.getEvent().detail("username", userIdentity.toString());
            context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", userIdentity.toString());
            user = this.getUserIdentityToModelMapper(config).find(context, userIdentity);
        }
        catch (ModelDuplicateException e) {
            logger.modelDuplicateException(e);
            String errorMessage = String.format("X509 certificate authentication's failed. Reason: \"%s\"", e.getMessage());
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_request", errorMessage);
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            String errorMessage = String.format("X509 certificate authentication's failed. Reason: \"%s\"", e.getMessage());
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_request", errorMessage);
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        if (user == null) {
            context.getEvent().error("invalid_user_credentials");
            Response challengeResponse = this.errorResponse(Response.Status.UNAUTHORIZED.getStatusCode(), "invalid_grant", "Invalid user credentials");
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        String bruteForceError = AuthenticatorUtils.getDisabledByBruteForceEventError(context.getProtector(), context.getSession(), context.getRealm(), user);
        if (bruteForceError != null) {
            context.getEvent().user(user);
            context.getEvent().error(bruteForceError);
            Response challengeResponse = this.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_grant", "Invalid user credentials");
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        if (!user.isEnabled()) {
            context.getEvent().user(user);
            context.getEvent().error("user_disabled");
            Response challengeResponse = this.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_grant", "Account disabled");
            context.failure(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        context.setUser(user);
        context.success();
    }

    @Override
    public void action(AuthenticationFlowContext context) {
    }
}

