/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.util.JsonSerialization;

public class AccessTokenIntrospectionProvider
implements TokenIntrospectionProvider {
    private final KeycloakSession session;
    private final TokenManager tokenManager;
    private final RealmModel realm;

    public AccessTokenIntrospectionProvider(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.tokenManager = new TokenManager();
    }

    public Response introspect(String token) {
        try {
            ObjectNode tokenMetadata;
            AccessToken accessToken = this.verifyAccessToken(token);
            if (accessToken != null) {
                tokenMetadata = JsonSerialization.createObjectNode((Object)accessToken);
                tokenMetadata.put("client_id", accessToken.getIssuedFor());
                if (!tokenMetadata.has("username")) {
                    if (accessToken.getPreferredUsername() != null) {
                        tokenMetadata.put("username", accessToken.getPreferredUsername());
                    } else {
                        UserModel userModel = this.session.users().getUserById(this.realm, accessToken.getSubject());
                        if (userModel != null) {
                            tokenMetadata.put("username", userModel.getUsername());
                        }
                    }
                }
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
            }
            tokenMetadata.put("active", accessToken != null);
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating token introspection response.", e);
        }
    }

    protected AccessToken verifyAccessToken(String token) {
        AccessToken accessToken;
        try {
            TokenVerifier verifier = TokenVerifier.create((String)token, AccessToken.class).realmUrl(Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
            SignatureVerifierContext verifierContext = ((SignatureProvider)this.session.getProvider(SignatureProvider.class, verifier.getHeader().getAlgorithm().name())).verifier(verifier.getHeader().getKeyId());
            verifier.verifierContext(verifierContext);
            accessToken = (AccessToken)verifier.verify().getToken();
        }
        catch (VerificationException e) {
            return null;
        }
        RealmModel realm = this.session.getContext().getRealm();
        return this.tokenManager.checkTokenValidForIntrospection(this.session, realm, accessToken, false) ? accessToken : null;
    }

    public void close() {
    }
}

