/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.provider.DefaultProviderLoader;
import org.keycloak.provider.DeploymentProviderLoader;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderLoader;
import org.keycloak.provider.ProviderLoaderFactory;
import org.keycloak.provider.Spi;

public class ProviderManager {
    private static final Logger logger = Logger.getLogger(ProviderManager.class);
    private final KeycloakDeploymentInfo info;
    private List<ProviderLoader> loaders = new LinkedList<ProviderLoader>();
    private MultivaluedHashMap<Class<? extends Provider>, ProviderFactory> cache = new MultivaluedHashMap();

    public ProviderManager(KeycloakDeploymentInfo info, ClassLoader baseClassLoader, String ... resources) {
        this.info = info;
        LinkedList<ProviderLoaderFactory> factories = new LinkedList<ProviderLoaderFactory>();
        for (ProviderLoaderFactory f : ServiceLoader.load(ProviderLoaderFactory.class, this.getClass().getClassLoader())) {
            factories.add(f);
        }
        logger.debugv("Provider loaders {0}", factories);
        this.loaders.add(new DefaultProviderLoader(info, baseClassLoader));
        this.loaders.add(new DeploymentProviderLoader(info));
        if (resources != null) {
            for (String r : resources) {
                String type = r.substring(0, r.indexOf(58));
                String resource = r.substring(r.indexOf(58) + 1, r.length());
                boolean found = false;
                for (ProviderLoaderFactory f : factories) {
                    if (!f.supports(type)) continue;
                    KeycloakDeploymentInfo resourceInfo = KeycloakDeploymentInfo.create().services();
                    this.loaders.add(f.create(resourceInfo, baseClassLoader, resource));
                    found = true;
                    break;
                }
                if (found) continue;
                throw new RuntimeException("Provider loader for " + r + " not found");
            }
        }
    }

    public synchronized List<Spi> loadSpis() {
        HashMap<String, Spi> spiMap = new HashMap<String, Spi>();
        for (ProviderLoader loader : this.loaders) {
            List spis = loader.loadSpis();
            if (spis == null) continue;
            for (Spi spi : spis) {
                spiMap.put(spi.getName(), spi);
            }
        }
        return new LinkedList<Spi>(spiMap.values());
    }

    public synchronized List<ProviderFactory> load(Spi spi) {
        List rtn;
        if (!this.cache.containsKey((Object)spi.getProviderClass())) {
            HashSet<String> loaded = new HashSet<String>();
            for (ProviderLoader loader : this.loaders) {
                List f = loader.load(spi);
                if (f == null) continue;
                for (ProviderFactory pf : f) {
                    String uniqueId = spi.getName() + "-" + pf.getId();
                    if (loaded.contains(uniqueId)) continue;
                    this.cache.add((Object)spi.getProviderClass(), (Object)pf);
                    loaded.add(uniqueId);
                }
            }
        }
        return (rtn = (List)this.cache.get((Object)spi.getProviderClass())) == null ? Collections.EMPTY_LIST : rtn;
    }

    public synchronized MultivaluedHashMap<Class<? extends Provider>, ProviderFactory> getLoadedFactories() {
        MultivaluedHashMap copy = new MultivaluedHashMap();
        copy.addAll(this.cache);
        return copy;
    }

    public synchronized ProviderFactory load(Spi spi, String providerId) {
        for (ProviderFactory f : this.load(spi)) {
            if (!f.getId().equals(providerId)) continue;
            return f;
        }
        return null;
    }

    public synchronized KeycloakDeploymentInfo getInfo() {
        return this.info;
    }
}

