/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.util.PemException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.x509.AbstractClientCertificateFromHttpHeadersLookup;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.truststore.TruststoreProviderFactory;

public class NginxProxySslClientCertificateLookup
extends AbstractClientCertificateFromHttpHeadersLookup {
    private static final Logger log = Logger.getLogger(NginxProxySslClientCertificateLookup.class);
    private static boolean isTruststoreLoaded = false;
    private static KeyStore truststore = null;
    private static Set<X509Certificate> trustedRootCerts = null;
    private static Set<X509Certificate> intermediateCerts = null;

    public NginxProxySslClientCertificateLookup(String sslCientCertHttpHeader, String sslCertChainHttpHeaderPrefix, int certificateChainLength, KeycloakSession kcsession) {
        super(sslCientCertHttpHeader, sslCertChainHttpHeaderPrefix, certificateChainLength);
        if (!this.loadKeycloakTrustStore(kcsession)) {
            log.warn((Object)"Keycloak Truststore is null or empty, but it's required for NGINX x509cert-lookup provider");
            log.warn((Object)"   see Keycloak documentation here : https://www.keycloak.org/docs/latest/server_installation/index.html#_truststore");
        }
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replace("-----BEGIN CERTIFICATE-----", "");
        pem = pem.replace("-----END CERTIFICATE-----", "");
        pem = pem.replace("\r\n", "");
        pem = pem.replace("\n", "");
        return pem.trim();
    }

    @Override
    protected X509Certificate decodeCertificateFromPem(String pem) throws PemException {
        if (pem == null) {
            log.warn((Object)"End user TLS Certificate is NULL! ");
            return null;
        }
        try {
            pem = URLDecoder.decode(pem, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Cannot URL decode the end user TLS Certificate : " + pem), (Throwable)e);
        }
        if (pem.startsWith("-----BEGIN CERTIFICATE-----")) {
            pem = NginxProxySslClientCertificateLookup.removeBeginEnd(pem);
        }
        return PemUtils.decodeCertificate((String)pem);
    }

    @Override
    public X509Certificate[] getCertificateChain(HttpRequest httpRequest) throws GeneralSecurityException {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        X509Certificate clientCert = this.getCertificateFromHttpHeader(httpRequest, this.sslClientCertHttpHeader);
        if (clientCert != null) {
            log.debugf("End user certificate found : Subject DN=[%s]  SerialNumber=[%s]", (Object)clientCert.getSubjectDN(), (Object)clientCert.getSerialNumber());
            X509Certificate[] certChain = this.buildChain(clientCert);
            if (certChain == null || certChain.length == 0) {
                log.info((Object)"Impossible to rebuild end user cert chain : client certificate authentication will fail.");
                chain.add(clientCert);
            } else {
                for (X509Certificate cacert : certChain) {
                    chain.add(cacert);
                    log.debugf("Rebuilded user cert chain DN : %s", (Object)cacert.getSubjectDN().toString());
                }
            }
        }
        return chain.toArray(new X509Certificate[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate[] buildChain(X509Certificate end_user_auth_cert) {
        X509Certificate[] user_cert_chain = null;
        try {
            if (!isTruststoreLoaded) {
                log.warn((Object)"Keycloak Truststore is null, but it is required !");
                log.warn((Object)"  see https://www.keycloak.org/docs/latest/server_installation/index.html#_truststore");
                X509Certificate[] x509CertificateArray = null;
                return x509CertificateArray;
            }
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(end_user_auth_cert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (X509Certificate trustedRootCert : trustedRootCerts) {
                trustAnchors.add(new TrustAnchor(trustedRootCert, null));
            }
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            pkixParams.setRevocationEnabled(false);
            pkixParams.setExplicitPolicyRequired(false);
            pkixParams.setAnyPolicyInhibited(false);
            pkixParams.setPolicyQualifiersRejected(false);
            pkixParams.setMaxPathLength(this.certificateChainLength);
            intermediateCerts.add(end_user_auth_cert);
            CollectionCertStoreParameters intermediateCA_userCert = new CollectionCertStoreParameters(intermediateCerts);
            CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)intermediateCA_userCert, "BC");
            pkixParams.addCertStore(intermediateCertStore);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", "BC");
            CertPath certPath = certPathBuilder.build(pkixParams).getCertPath();
            log.debug((Object)("Certification path building OK, and contains " + certPath.getCertificates().size() + " X509 Certificates"));
            user_cert_chain = this.convertCertPathtoX509CertArray(certPath);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (CertPathBuilderException e) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            } else {
                log.warn((Object)e.getLocalizedMessage());
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (isTruststoreLoaded) {
                intermediateCerts.remove(end_user_auth_cert);
            }
        }
        return user_cert_chain;
    }

    public X509Certificate[] convertCertPathtoX509CertArray(CertPath certPath) {
        X509Certificate[] x509certchain = null;
        if (certPath != null) {
            ArrayList<X509Certificate> trustedX509Chain = new ArrayList<X509Certificate>();
            for (Certificate certificate : certPath.getCertificates()) {
                if (!(certificate instanceof X509Certificate)) continue;
                trustedX509Chain.add((X509Certificate)certificate);
            }
            x509certchain = trustedX509Chain.toArray(new X509Certificate[0]);
        }
        return x509certchain;
    }

    public boolean loadKeycloakTrustStore(KeycloakSession kcsession) {
        if (!isTruststoreLoaded) {
            log.debug((Object)" Loading Keycloak truststore ...");
            KeycloakSessionFactory factory = kcsession.getKeycloakSessionFactory();
            TruststoreProviderFactory truststoreFactory = (TruststoreProviderFactory)factory.getProviderFactory(TruststoreProvider.class, "file");
            TruststoreProvider provider = (TruststoreProvider)truststoreFactory.create(kcsession);
            if (provider != null && provider.getTruststore() != null) {
                truststore = provider.getTruststore();
                trustedRootCerts = new HashSet(provider.getRootCertificates().values());
                intermediateCerts = new HashSet(provider.getIntermediateCertificates().values());
                log.debug((Object)"Keycloak truststore loaded for NGINX x509cert-lookup provider.");
                isTruststoreLoaded = true;
            }
        }
        return isTruststoreLoaded;
    }
}

