/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.ContentTypeConfiguration;
import org.infinispan.configuration.parsing.Element;

public final class EncodingConfiguration
implements Matchable<EncodingConfiguration>,
ConfigurationInfo {
    static final AttributeDefinition<String> MEDIA_TYPE = AttributeDefinition.builder((String)"mediaType", null, String.class).build();
    private final AttributeSet attributes;
    private final ContentTypeConfiguration keyDataType;
    private final ContentTypeConfiguration valueDataType;
    private final List<ConfigurationInfo> contentTypeConfigurations;
    static final ElementDefinition<EncodingConfiguration> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.ENCODING.getLocalName());

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(EncodingConfiguration.class, new AttributeDefinition[]{MEDIA_TYPE});
    }

    public EncodingConfiguration(AttributeSet attributes, ContentTypeConfiguration keyDataType, ContentTypeConfiguration valueDataType) {
        this.attributes = attributes;
        this.keyDataType = keyDataType;
        this.valueDataType = valueDataType;
        this.contentTypeConfigurations = Arrays.asList(keyDataType, valueDataType);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ContentTypeConfiguration keyDataType() {
        return this.keyDataType;
    }

    public ContentTypeConfiguration valueDataType() {
        return this.valueDataType;
    }

    public String toString() {
        return "EncodingConfiguration{attributes=" + this.attributes + ", keyDataType=" + this.keyDataType + ", valueDataType=" + this.valueDataType + '}';
    }

    public ElementDefinition<EncodingConfiguration> getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingConfiguration that = (EncodingConfiguration)o;
        if (!this.attributes.equals((Object)that.attributes)) {
            return false;
        }
        if (!this.keyDataType.equals(that.keyDataType)) {
            return false;
        }
        return this.valueDataType.equals(that.valueDataType);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.keyDataType.hashCode();
        result = 31 * result + this.valueDataType.hashCode();
        return result;
    }

    public List<ConfigurationInfo> subElements() {
        return this.contentTypeConfigurations;
    }
}

