/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserLoginFailureProvider;
import org.keycloak.models.sessions.infinispan.changes.LoginFailuresUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;

public class UserLoginFailureAdapter
implements UserLoginFailureModel {
    private InfinispanUserLoginFailureProvider provider;
    private LoginFailureKey key;
    private LoginFailureEntity entity;

    public UserLoginFailureAdapter(InfinispanUserLoginFailureProvider provider, LoginFailureKey key, LoginFailureEntity entity) {
        this.provider = provider;
        this.key = key;
        this.entity = entity;
    }

    public String getUserId() {
        return this.entity.getUserId();
    }

    public int getFailedLoginNotBefore() {
        return this.entity.getFailedLoginNotBefore();
    }

    public void setFailedLoginNotBefore(final int notBefore) {
        LoginFailuresUpdateTask task = new LoginFailuresUpdateTask(){

            @Override
            public void runUpdate(LoginFailureEntity entity) {
                entity.setFailedLoginNotBefore(notBefore);
            }
        };
        this.update(task);
    }

    public int getNumFailures() {
        return this.entity.getNumFailures();
    }

    public void incrementFailures() {
        LoginFailuresUpdateTask task = new LoginFailuresUpdateTask(){

            @Override
            public void runUpdate(LoginFailureEntity entity) {
                entity.setNumFailures(entity.getNumFailures() + 1);
            }
        };
        this.update(task);
    }

    public void clearFailures() {
        LoginFailuresUpdateTask task = new LoginFailuresUpdateTask(){

            @Override
            public void runUpdate(LoginFailureEntity entity) {
                entity.clearFailures();
            }
        };
        this.update(task);
    }

    public long getLastFailure() {
        return this.entity.getLastFailure();
    }

    public void setLastFailure(final long lastFailure) {
        LoginFailuresUpdateTask task = new LoginFailuresUpdateTask(){

            @Override
            public void runUpdate(LoginFailureEntity entity) {
                entity.setLastFailure(lastFailure);
            }
        };
        this.update(task);
    }

    public String getLastIPFailure() {
        return this.entity.getLastIPFailure();
    }

    public void setLastIPFailure(final String ip) {
        LoginFailuresUpdateTask task = new LoginFailuresUpdateTask(){

            @Override
            public void runUpdate(LoginFailureEntity entity) {
                entity.setLastIPFailure(ip);
            }
        };
        this.update(task);
    }

    void update(LoginFailuresUpdateTask task) {
        this.provider.getLoginFailuresTx().addTask(this.key, task);
    }

    public String getId() {
        return this.key.toString();
    }
}

