/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.events.SessionClusterEvent;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.Provider;

public abstract class AbstractUserSessionClusterListener<SE extends SessionClusterEvent, T extends Provider>
implements ClusterListener {
    private static final Logger log = Logger.getLogger(AbstractUserSessionClusterListener.class);
    private final KeycloakSessionFactory sessionFactory;
    private final Class<T> providerClazz;

    public AbstractUserSessionClusterListener(KeycloakSessionFactory sessionFactory, Class<T> providerClazz) {
        this.sessionFactory = sessionFactory;
        this.providerClazz = providerClazz;
    }

    public void eventReceived(ClusterEvent event) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
            Provider provider = session.getProvider(this.providerClazz);
            SessionClusterEvent sessionEvent = (SessionClusterEvent)event;
            boolean shouldResendEvent = this.shouldResendEvent(session, sessionEvent);
            if (log.isDebugEnabled()) {
                log.debugf("Received user session event '%s'. Should resend event: %b", (Object)sessionEvent.toString(), (Object)shouldResendEvent);
            }
            this.eventReceived(session, provider, sessionEvent);
            if (shouldResendEvent) {
                ((ClusterProvider)session.getProvider(ClusterProvider.class)).notify(sessionEvent.getEventKey(), event, true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
            }
        });
    }

    protected abstract void eventReceived(KeycloakSession var1, T var2, SE var3);

    private boolean shouldResendEvent(KeycloakSession session, SessionClusterEvent event) {
        if (!event.isResendingEvent()) {
            return false;
        }
        TopologyInfo topology = InfinispanUtil.getTopologyInfo(session);
        String myNode = topology.getMyNodeName();
        String mySite = topology.getMySiteName();
        return event.getNodeId() != null && event.getNodeId().equals(myNode) && event.getSiteId() != null && event.getSiteId().equals(mySite);
    }
}

