/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.loginFailure;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserLoginFailureProviderFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntity;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class MapUserLoginFailureProviderFactory
extends AbstractMapProviderFactory<UserLoginFailureProvider, MapUserLoginFailureEntity, UserLoginFailureModel>
implements UserLoginFailureProviderFactory,
ProviderEventListener {
    private Runnable onClose;

    public MapUserLoginFailureProviderFactory() {
        super(UserLoginFailureModel.class);
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
        this.onClose = () -> factory.unregister((ProviderEventListener)this);
    }

    public void close() {
        super.close();
        this.onClose.run();
    }

    public MapUserLoginFailureProvider create(KeycloakSession session) {
        return new MapUserLoginFailureProvider(session, this.getStorage(session));
    }

    public String getHelpText() {
        return "User login failure provider";
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof UserModel.UserRemovedEvent) {
            UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
            MapUserLoginFailureProvider provider = this.create(userRemovedEvent.getKeycloakSession());
            provider.removeUserLoginFailure(userRemovedEvent.getRealm(), userRemovedEvent.getUser().getId());
        } else if (event instanceof RealmModel.RealmRemovedEvent) {
            RealmModel.RealmRemovedEvent realmRemovedEvent = (RealmModel.RealmRemovedEvent)event;
            MapUserLoginFailureProvider provider = this.create(realmRemovedEvent.getKeycloakSession());
            provider.removeAllUserLoginFailures(realmRemovedEvent.getRealm());
        }
    }
}

