/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.Objects;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapClientInitialAccessEntity
implements UpdatableEntity {
    private String id;
    private Integer timestamp = 0;
    private Integer expiration = 0;
    private Integer count = 0;
    private Integer remainingCount = 0;
    private boolean updated;

    private MapClientInitialAccessEntity() {
    }

    public static MapClientInitialAccessEntity createEntity(int expiration, int count) {
        int currentTime = Time.currentTime();
        MapClientInitialAccessEntity entity = new MapClientInitialAccessEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(currentTime);
        entity.setExpiration(expiration);
        entity.setCount(count);
        entity.setRemainingCount(count);
        return entity;
    }

    public static ClientInitialAccessModel toModel(MapClientInitialAccessEntity entity) {
        if (entity == null) {
            return null;
        }
        ClientInitialAccessModel model = new ClientInitialAccessModel();
        model.setId(entity.getId());
        model.setTimestamp(entity.getTimestamp().intValue());
        model.setExpiration(entity.getExpiration().intValue());
        model.setCount(entity.getCount().intValue());
        model.setRemainingCount(entity.getRemainingCount().intValue());
        return model;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.updated = !Objects.equals(this.id, id);
        this.id = id;
    }

    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.updated = !Objects.equals(this.timestamp, timestamp);
        this.timestamp = timestamp;
    }

    public Integer getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.updated = !Objects.equals(this.expiration, expiration);
        this.expiration = expiration;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.updated = !Objects.equals(this.count, count);
        this.count = count;
    }

    public Integer getRemainingCount() {
        return this.remainingCount;
    }

    public void setRemainingCount(int remainingCount) {
        this.updated = !Objects.equals(this.remainingCount, remainingCount);
        this.remainingCount = remainingCount;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapClientInitialAccessEntity)) {
            return false;
        }
        MapClientInitialAccessEntity other = (MapClientInitialAccessEntity)obj;
        return Objects.equals(other.getId(), this.getId());
    }
}

