/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class UserConsentEntity
implements UpdatableEntity {
    private String clientId;
    private final Set<String> grantedClientScopesIds = new HashSet<String>();
    private Long createdDate;
    private Long lastUpdatedDate;
    private boolean updated;

    private UserConsentEntity() {
    }

    public static UserConsentEntity fromModel(UserConsentModel model) {
        long currentTime = Time.currentTimeMillis();
        UserConsentEntity consentEntity = new UserConsentEntity();
        consentEntity.setClientId(model.getClient().getId());
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        model.getGrantedClientScopes().stream().map(ClientScopeModel::getId).forEach(consentEntity::addGrantedClientScopeId);
        return consentEntity;
    }

    public static UserConsentModel toModel(RealmModel realm, UserConsentEntity entity) {
        if (entity == null) {
            return null;
        }
        ClientModel client = realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        entity.getGrantedClientScopesIds().stream().map(scopeId -> KeycloakModelUtils.findClientScopeById((RealmModel)realm, (ClientModel)client, (String)scopeId)).filter(Objects::nonNull).forEach(arg_0 -> ((UserConsentModel)model).addGrantedClientScope(arg_0));
        return model;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.updated = !Objects.equals(this.clientId, clientId);
        this.clientId = clientId;
    }

    public Set<String> getGrantedClientScopesIds() {
        return this.grantedClientScopesIds;
    }

    public void addGrantedClientScopeId(String scope) {
        this.updated |= this.grantedClientScopesIds.add(scope);
    }

    public void setGrantedClientScopesIds(Set<String> scopesIds) {
        this.updated |= !Objects.equals(this.grantedClientScopesIds, scopesIds);
        this.grantedClientScopesIds.clear();
        this.grantedClientScopesIds.addAll(scopesIds);
    }

    public void removeGrantedClientScopesIds(String scopesId) {
        this.updated |= this.grantedClientScopesIds.remove(scopesId);
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.updated |= !Objects.equals(this.createdDate, createdDate);
        this.createdDate = createdDate;
    }

    public Long getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Long lastUpdatedDate) {
        this.updated |= !Objects.equals(this.lastUpdatedDate, lastUpdatedDate);
        this.lastUpdatedDate = lastUpdatedDate;
    }
}

