/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.x500;

import com.webauthn4j.data.x500.Attributes;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class X500Name
extends AbstractList<Attributes>
implements Serializable {
    private final int size;
    private final Attributes[] attributes;

    public X500Name(String value) {
        this(Arrays.stream(value.split(",")).map(Attributes::new).collect(Collectors.toList()));
    }

    public X500Name(List<Attributes> attributes) {
        AssertUtil.notNull(attributes, (String)"attributes must not be null");
        this.size = attributes.size();
        this.attributes = attributes.toArray(new Attributes[this.size]);
    }

    public X500Name() {
        this(Collections.emptyList());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Attributes get(int index) {
        return this.attributes[index];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        X500Name that = (X500Name)o;
        return this.size == that.size && Arrays.equals(this.attributes, that.attributes);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.size);
        result = 31 * result + Arrays.hashCode(this.attributes);
        return result;
    }
}

