/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import io.smallrye.mutiny.helpers.test.AssertionHelper;
import io.smallrye.mutiny.helpers.test.OnCancellationUniSignal;
import io.smallrye.mutiny.helpers.test.OnFailureUniSignal;
import io.smallrye.mutiny.helpers.test.OnItemUniSignal;
import io.smallrye.mutiny.helpers.test.OnSubscribeUniSignal;
import io.smallrye.mutiny.helpers.test.UniSignal;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class UniAssertSubscriber<T>
implements UniSubscriber<T> {
    private volatile boolean cancelImmediatelyOnSubscription;
    private volatile UniSubscription subscription;
    private volatile T item;
    private volatile Throwable failure;
    private volatile boolean completed;
    private final CompletableFuture<T> future = new CompletableFuture();
    private volatile String onResultThreadName;
    private volatile String onErrorThreadName;
    private volatile String onSubscribeThreadName;
    private final List<UniSignal> signals = new ArrayList<UniSignal>(4);

    public UniAssertSubscriber(boolean cancelled) {
        this.cancelImmediatelyOnSubscription = cancelled;
    }

    public UniAssertSubscriber() {
        this(false);
    }

    public static <T> UniAssertSubscriber<T> create() {
        return new UniAssertSubscriber<T>();
    }

    @Override
    public synchronized void onSubscribe(UniSubscription subscription) {
        this.signals.add(new OnSubscribeUniSignal(subscription));
        this.onSubscribeThreadName = Thread.currentThread().getName();
        if (this.cancelImmediatelyOnSubscription) {
            this.subscription = subscription;
            subscription.cancel();
            this.future.cancel(false);
            return;
        }
        this.subscription = subscription;
    }

    @Override
    public synchronized void onItem(T item) {
        this.signals.add(new OnItemUniSignal<T>(item));
        this.completed = true;
        this.item = item;
        this.onResultThreadName = Thread.currentThread().getName();
        this.future.complete(item);
    }

    @Override
    public synchronized void onFailure(Throwable failure) {
        this.signals.add(new OnFailureUniSignal(failure));
        this.failure = failure;
        this.onErrorThreadName = Thread.currentThread().getName();
        this.future.completeExceptionally(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniAssertSubscriber<T> await() {
        CompletableFuture<T> fut;
        UniAssertSubscriber uniAssertSubscriber = this;
        synchronized (uniAssertSubscriber) {
            fut = this.future;
        }
        try {
            fut.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertCompleted() {
        AssertionHelper.shouldHaveCompleted(this.completed, this.failure, null);
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertFailed() {
        AssertionHelper.shouldHaveFailed(this.completed, this.failure, null, null);
        return this;
    }

    public synchronized T getItem() {
        return this.item;
    }

    public synchronized Throwable getFailure() {
        return this.failure;
    }

    public UniAssertSubscriber<T> assertItem(T expected) {
        AssertionHelper.shouldHaveCompleted(this.completed, this.failure, null);
        AssertionHelper.shouldHaveReceived(this.getItem(), expected);
        return this;
    }

    public UniAssertSubscriber<T> assertFailedWith(Class<? extends Throwable> expectedTypeOfFailure, String expectedMessage) {
        AssertionHelper.shouldHaveFailed(this.completed, this.failure, expectedTypeOfFailure, expectedMessage);
        return this;
    }

    public String getOnItemThreadName() {
        return this.onResultThreadName;
    }

    public String getOnFailureThreadName() {
        return this.onErrorThreadName;
    }

    public String getOnSubscribeThreadName() {
        return this.onSubscribeThreadName;
    }

    public void cancel() {
        this.signals.add(new OnCancellationUniSignal());
        if (this.subscription == null) {
            this.cancelImmediatelyOnSubscription = true;
        } else {
            this.subscription.cancel();
        }
    }

    public UniAssertSubscriber<T> assertTerminated() {
        AssertionHelper.shouldBeTerminated(this.completed, this.failure);
        return this;
    }

    public UniAssertSubscriber<T> assertNotTerminated() {
        AssertionHelper.shouldNotBeTerminated(this.completed, this.failure);
        return this;
    }

    public UniAssertSubscriber<T> assertSubscribed() {
        AssertionHelper.shouldBeSubscribed(this.subscription == null ? 0 : 1);
        return this;
    }

    public UniAssertSubscriber<T> assertNotSubscribed() {
        AssertionHelper.shouldNotBeSubscribed(this.subscription == null ? 0 : 1);
        return this;
    }

    public List<UniSignal> getSignals() {
        return Collections.unmodifiableList(this.signals);
    }

    public UniAssertSubscriber<T> assertSignalsReceivedInOrder() {
        if (this.signals.isEmpty()) {
            return this;
        }
        UniSignal firstSignal = this.signals.get(0);
        if (!(firstSignal instanceof OnSubscribeUniSignal) && !(firstSignal instanceof OnCancellationUniSignal)) {
            throw new AssertionError((Object)("The first signal is neither onSubscribe nor cancel but " + firstSignal));
        }
        int[] occurrences = new int[3];
        for (UniSignal signal : this.signals) {
            if (signal instanceof OnSubscribeUniSignal) {
                occurrences[0] = occurrences[0] + 1;
                continue;
            }
            if (signal instanceof OnItemUniSignal) {
                occurrences[1] = occurrences[1] + 1;
                continue;
            }
            if (!(signal instanceof OnFailureUniSignal)) continue;
            occurrences[2] = occurrences[2] + 1;
        }
        if (occurrences[0] > 1) {
            throw new AssertionError((Object)("There are more than 1 onSubscribe signals in " + this.signals));
        }
        if (occurrences[1] > 1) {
            throw new AssertionError((Object)("There are more than 1 onItem signals in " + this.signals));
        }
        if (occurrences[2] > 1) {
            throw new AssertionError((Object)("There are more than 1 onFailure signals in " + this.signals));
        }
        if (occurrences[1] == 1 && occurrences[2] == 1) {
            throw new AssertionError((Object)("There are both onItem and onFailure signals in " + this.signals));
        }
        return this;
    }
}

