/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.UserAuthPassword;
import org.apache.sshd.client.session.ClientSession;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.SshdText;

public class JGitPasswordAuthentication
extends UserAuthPassword {
    private int maxAttempts;
    private int attempts;

    public void init(ClientSession session, String service) throws Exception {
        super.init(session, service);
        this.maxAttempts = Math.max(1, session.getIntProperty("password-prompts", 3));
        this.attempts = 0;
    }

    protected boolean sendAuthDataRequest(ClientSession session, String service) throws Exception {
        if (++this.attempts > this.maxAttempts) {
            return false;
        }
        UserInteraction interaction = session.getUserInteraction();
        if (!interaction.isInteractionAllowed(session)) {
            return false;
        }
        String password = this.getPassword(session, interaction);
        if (password == null) {
            throw new AuthenticationCanceledException();
        }
        this.sendPassword(null, session, password, password);
        return true;
    }

    private String getPassword(ClientSession session, UserInteraction interaction) {
        String[] results = interaction.interactive(session, null, null, "", new String[]{SshdText.get().passwordPrompt}, new boolean[1]);
        return results == null || results.length == 0 ? null : results[0];
    }
}

