/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.clientscope.MapClientScopeAdapter;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;

public class MapClientScopeProvider
implements ClientScopeProvider {
    private static final Logger LOG = Logger.getLogger(MapClientScopeProvider.class);
    private final KeycloakSession session;
    private final MapKeycloakTransaction<MapClientScopeEntity, ClientScopeModel> tx;
    private final MapStorage<MapClientScopeEntity, ClientScopeModel> clientScopeStore;

    public MapClientScopeProvider(KeycloakSession session, MapStorage<MapClientScopeEntity, ClientScopeModel> clientScopeStore) {
        this.session = session;
        this.clientScopeStore = clientScopeStore;
        this.tx = clientScopeStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapClientScopeEntity, ClientScopeModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapClientScopeAdapter(this.session, realm, (MapClientScopeEntity)origEntity);
    }

    private Predicate<MapClientScopeEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return c -> false;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public Stream<ClientScopeModel> getClientScopesStream(RealmModel realm) {
        ModelCriteriaBuilder<ClientScopeModel> mcb = this.clientScopeStore.createCriteriaBuilder().compare((SearchableModelField<ClientScopeModel>)ClientScopeModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy((SearchableModelField<ClientScopeModel>)ClientScopeModel.SearchableFields.NAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public ClientScopeModel addClientScope(RealmModel realm, String id, String name) {
        ModelCriteriaBuilder<ClientScopeModel> mcb = this.clientScopeStore.createCriteriaBuilder().compare((SearchableModelField<ClientScopeModel>)ClientScopeModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<ClientScopeModel>)ClientScopeModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name);
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("Client scope with name '" + name + "' in realm " + realm.getName());
        }
        LOG.tracef("addClientScope(%s, %s, %s)%s", new Object[]{realm, id, name, StackUtil.getShortStackTrace()});
        MapClientScopeEntity entity = new MapClientScopeEntity(id, realm.getId());
        entity.setName(KeycloakModelUtils.convertClientScopeName((String)name));
        if (id != null && this.tx.read(id) != null) {
            throw new ModelDuplicateException("Client scope exists: " + id);
        }
        entity = this.tx.create(entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public boolean removeClientScope(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        final ClientScopeModel clientScope = this.getClientScopeById(realm, id);
        if (clientScope == null) {
            return false;
        }
        this.session.users().preRemove(clientScope);
        realm.removeDefaultClientScope(clientScope);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientScopeModel.ClientScopeRemovedEvent(){

            public KeycloakSession getKeycloakSession() {
                return MapClientScopeProvider.this.session;
            }

            public ClientScopeModel getClientScope() {
                return clientScope;
            }
        });
        this.tx.delete(id);
        return true;
    }

    public void removeClientScopes(RealmModel realm) {
        LOG.tracef("removeClients(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.getClientScopesStream(realm).map(ClientScopeModel::getId).collect(Collectors.toSet()).forEach(id -> this.removeClientScope(realm, (String)id));
    }

    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getClientScopeById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapClientScopeEntity entity = this.tx.read(id);
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public void close() {
    }
}

