/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.Objects;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapRequiredCredentialEntity
implements UpdatableEntity {
    private String type;
    private String formLabel;
    private Boolean input = false;
    private Boolean secret = false;
    private boolean updated;

    private MapRequiredCredentialEntity() {
    }

    public static MapRequiredCredentialEntity fromModel(RequiredCredentialModel model) {
        if (model == null) {
            return null;
        }
        MapRequiredCredentialEntity entity = new MapRequiredCredentialEntity();
        entity.setFormLabel(model.getFormLabel());
        entity.setType(model.getType());
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        return entity;
    }

    public static RequiredCredentialModel toModel(MapRequiredCredentialEntity entity) {
        if (entity == null) {
            return null;
        }
        RequiredCredentialModel model = new RequiredCredentialModel();
        model.setFormLabel(entity.getFormLabel());
        model.setType(entity.getType());
        model.setSecret(entity.isSecret().booleanValue());
        model.setInput(entity.isInput().booleanValue());
        return model;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.updated = !Objects.equals(this.type, type);
        this.type = type;
    }

    public String getFormLabel() {
        return this.formLabel;
    }

    public void setFormLabel(String formLabel) {
        this.updated = !Objects.equals(this.formLabel, formLabel);
        this.formLabel = formLabel;
    }

    public Boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean secret) {
        this.updated = !Objects.equals(this.formLabel, this.formLabel);
        this.secret = secret;
    }

    public Boolean isInput() {
        return this.input;
    }

    public void setInput(boolean input) {
        this.updated = !Objects.equals(this.input, input);
        this.input = input;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapRequiredCredentialEntity)) {
            return false;
        }
        MapRequiredCredentialEntity other = (MapRequiredCredentialEntity)obj;
        return Objects.equals(other.getType(), this.getType());
    }
}

