/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.strategy.AuditStrategy;

public final class TwoEntityOneAuditedQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String queryString;
    private final String queryRemovedString;

    public TwoEntityOneAuditedQueryGenerator(AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, boolean revisionTypeInId, MiddleComponentData ... componentData) {
        super(verEntCfg, referencingIdData, revisionTypeInId);
        QueryBuilder commonPart = this.commonQueryPart(referencedIdData, versionsMiddleEntityName, verEntCfg.getOriginalIdPropName());
        QueryBuilder validQuery = commonPart.deepCopy();
        QueryBuilder removedQuery = commonPart.deepCopy();
        this.createValidDataRestrictions(auditStrategy, versionsMiddleEntityName, validQuery, validQuery.getRootParameters(), componentData);
        this.createValidAndRemovedDataRestrictions(auditStrategy, versionsMiddleEntityName, removedQuery, componentData);
        this.queryString = this.queryToString(validQuery);
        this.queryRemovedString = this.queryToString(removedQuery);
    }

    private QueryBuilder commonQueryPart(MiddleIdData referencedIdData, String versionsMiddleEntityName, String originalIdPropertyName) {
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        QueryBuilder qb = new QueryBuilder(versionsMiddleEntityName, "ee__");
        qb.addFrom(referencedIdData.getEntityName(), "e__");
        qb.addProjection("new list", "ee__, e__", false, false);
        Parameters rootParameters = qb.getRootParameters();
        referencedIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, referencedIdData.getOriginalMapper(), "e__");
        this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        return qb;
    }

    private void createValidDataRestrictions(AuditStrategy auditStrategy, String versionsMiddleEntityName, QueryBuilder qb, Parameters rootParameters, MiddleComponentData ... componentData) {
        String revisionPropertyPath = this.verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = this.verEntCfg.getOriginalIdPropName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        auditStrategy.addAssociationAtRevisionRestriction(qb, rootParameters, revisionPropertyPath, this.verEntCfg.getRevisionEndFieldName(), true, this.referencingIdData, versionsMiddleEntityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, "ee__", true, componentData);
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), "!=", "delrevisiontype");
    }

    private void createValidAndRemovedDataRestrictions(AuditStrategy auditStrategy, String versionsMiddleEntityName, QueryBuilder remQb, MiddleComponentData ... componentData) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        this.createValidDataRestrictions(auditStrategy, versionsMiddleEntityName, remQb, valid, componentData);
        removed.addWhereWithNamedParam(this.verEntCfg.getRevisionNumberPath(), "=", "revision");
        removed.addWhereWithNamedParam(this.getRevisionTypePath(), "=", "delrevisiontype");
    }

    @Override
    protected String getQueryString() {
        return this.queryString;
    }

    @Override
    protected String getQueryRemovedString() {
        return this.queryRemovedString;
    }
}

