/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.adapter;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.mongo.entities.ScopeEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;

public class ScopeAdapter
extends AbstractMongoAdapter<ScopeEntity>
implements Scope {
    private final ScopeEntity entity;
    private final AuthorizationProvider authorizationProvider;

    public ScopeAdapter(ScopeEntity entity, MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        super(invocationContext);
        this.entity = entity;
        this.authorizationProvider = authorizationProvider;
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getName() {
        return this.getMongoEntity().getName();
    }

    public void setName(String name) {
        this.getMongoEntity().setName(name);
        this.updateMongoEntity();
    }

    public String getIconUri() {
        return this.getMongoEntity().getIconUri();
    }

    public void setIconUri(String iconUri) {
        this.getMongoEntity().setIconUri(iconUri);
        this.updateMongoEntity();
    }

    public ResourceServer getResourceServer() {
        return this.authorizationProvider.getStoreFactory().getResourceServerStore().findById(this.getMongoEntity().getResourceServerId());
    }

    @Override
    protected ScopeEntity getMongoEntity() {
        return this.entity;
    }
}

