/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;
import java.util.Set;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.exception.LiquibaseException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Reflections;
import org.keycloak.connections.jpa.entityprovider.JpaEntityProvider;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.updater.liquibase.ThreadLocalSessionContext;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.KeycloakSession;

public class LiquibaseJpaUpdaterProvider
implements JpaUpdaterProvider {
    private static final Logger logger = Logger.getLogger(LiquibaseJpaUpdaterProvider.class);
    public static final String CHANGELOG = "META-INF/jpa-changelog-master.xml";
    public static final String DB2_CHANGELOG = "META-INF/db2-jpa-changelog-master.xml";
    private final KeycloakSession session;

    public LiquibaseJpaUpdaterProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public void update(Connection connection, String defaultSchema) {
        logger.debug((Object)"Starting database update");
        ThreadLocalSessionContext.setCurrentSession(this.session);
        try {
            Liquibase liquibase = this.getLiquibaseForKeycloakUpdate(connection, defaultSchema);
            this.updateChangeSet(liquibase, liquibase.getChangeLogFile());
            Set jpaProviders = this.session.getAllProviders(JpaEntityProvider.class);
            for (JpaEntityProvider jpaProvider : jpaProviders) {
                String customChangelog = jpaProvider.getChangelogLocation();
                if (customChangelog == null) continue;
                String factoryId = jpaProvider.getFactoryId();
                String changelogTableName = JpaUtils.getCustomChangelogTableName(factoryId);
                liquibase = this.getLiquibaseForCustomProviderUpdate(connection, defaultSchema, customChangelog, jpaProvider.getClass().getClassLoader(), changelogTableName);
                this.updateChangeSet(liquibase, liquibase.getChangeLogFile());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update database", e);
        }
        finally {
            ThreadLocalSessionContext.removeCurrentSession();
        }
    }

    protected void updateChangeSet(Liquibase liquibase, String changelog) throws LiquibaseException {
        List changeSets = liquibase.listUnrunChangeSets((Contexts)null);
        if (!changeSets.isEmpty()) {
            List ranChangeSets = liquibase.getDatabase().getRanChangeSetList();
            if (ranChangeSets.isEmpty()) {
                logger.infov("Initializing database schema. Using changelog {0}", (Object)changelog);
            } else if (logger.isDebugEnabled()) {
                logger.debugv("Updating database from {0} to {1}. Using changelog {2}", (Object)((RanChangeSet)ranChangeSets.get(ranChangeSets.size() - 1)).getId(), (Object)((ChangeSet)changeSets.get(changeSets.size() - 1)).getId(), (Object)changelog);
            } else {
                logger.infov("Updating database. Using changelog {0}", (Object)changelog);
            }
            liquibase.update((Contexts)null);
            logger.debugv("Completed database update for changelog {0}", (Object)changelog);
        } else {
            logger.debugv("Database is up to date for changelog {0}", (Object)changelog);
            Method resetServices = Reflections.findDeclaredMethod(Liquibase.class, (String)"resetServices", (Class[])new Class[0]);
            Reflections.invokeMethod((boolean)true, (Method)resetServices, (Object)liquibase, (Object[])new Object[0]);
        }
    }

    @Override
    public void validate(Connection connection, String defaultSchema) {
        logger.debug((Object)"Validating if database is updated");
        try {
            Liquibase liquibase = this.getLiquibaseForKeycloakUpdate(connection, defaultSchema);
            this.validateChangeSet(liquibase, liquibase.getChangeLogFile());
            Set jpaProviders = this.session.getAllProviders(JpaEntityProvider.class);
            for (JpaEntityProvider jpaProvider : jpaProviders) {
                String customChangelog = jpaProvider.getChangelogLocation();
                if (customChangelog == null) continue;
                String factoryId = jpaProvider.getFactoryId();
                String changelogTableName = JpaUtils.getCustomChangelogTableName(factoryId);
                liquibase = this.getLiquibaseForCustomProviderUpdate(connection, defaultSchema, customChangelog, jpaProvider.getClass().getClassLoader(), changelogTableName);
                this.validateChangeSet(liquibase, liquibase.getChangeLogFile());
            }
        }
        catch (LiquibaseException e) {
            throw new RuntimeException("Failed to validate database", e);
        }
    }

    protected void validateChangeSet(Liquibase liquibase, String changelog) throws LiquibaseException {
        List changeSets = liquibase.listUnrunChangeSets((Contexts)null);
        if (!changeSets.isEmpty()) {
            List ranChangeSets = liquibase.getDatabase().getRanChangeSetList();
            String errorMessage = String.format("Failed to validate database schema. Schema needs updating database from %s to %s. Please change databaseSchema to 'update' or use other database. Used changelog was %s", ((RanChangeSet)ranChangeSets.get(ranChangeSets.size() - 1)).getId(), ((ChangeSet)changeSets.get(changeSets.size() - 1)).getId(), changelog);
            throw new RuntimeException(errorMessage);
        }
        logger.debugf("Validation passed. Database is up-to-date for changelog %s", (Object)changelog);
    }

    private Liquibase getLiquibaseForKeycloakUpdate(Connection connection, String defaultSchema) throws LiquibaseException {
        LiquibaseConnectionProvider liquibaseProvider = (LiquibaseConnectionProvider)this.session.getProvider(LiquibaseConnectionProvider.class);
        return liquibaseProvider.getLiquibase(connection, defaultSchema);
    }

    private Liquibase getLiquibaseForCustomProviderUpdate(Connection connection, String defaultSchema, String changelogLocation, ClassLoader classloader, String changelogTableName) throws LiquibaseException {
        LiquibaseConnectionProvider liquibaseProvider = (LiquibaseConnectionProvider)this.session.getProvider(LiquibaseConnectionProvider.class);
        return liquibaseProvider.getLiquibaseForCustomUpdate(connection, defaultSchema, changelogLocation, classloader, changelogTableName);
    }

    public void close() {
    }

    public static String getTable(String table, String defaultSchema) {
        return defaultSchema != null ? defaultSchema + "." + table : table;
    }
}

