/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.models.AccountRoles;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmImporter;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.UsersSyncManager;

public class RealmManager
implements RealmImporter {
    protected KeycloakSession session;
    protected RealmProvider model;
    protected String contextPath = "";

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public RealmManager(KeycloakSession session) {
        this.session = session;
        this.model = session.realms();
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealm(Config.getAdminRealm());
    }

    public RealmModel getRealm(String id) {
        return this.model.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.model.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(name, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.model.createRealm(id, name);
        realm.setName(name);
        this.setupRealmDefaults(realm);
        this.setupMasterAdminManagement(realm);
        this.setupRealmAdminManagement(realm);
        this.setupAccountManagement(realm);
        this.setupBrokerService(realm);
        this.setupAdminConsole(realm);
        this.setupAdminConsoleLocaleMapper(realm);
        this.setupAdminCli(realm);
        this.setupImpersonationService(realm);
        this.setupAuthenticationFlows(realm);
        this.setupRequiredActions(realm);
        this.setupOfflineTokens(realm);
        this.setupAuthorizationServices(realm);
        return realm;
    }

    protected void setupAuthenticationFlows(RealmModel realm) {
        if (realm.getAuthenticationFlows().size() == 0) {
            DefaultAuthenticationFlows.addFlows((RealmModel)realm);
        }
    }

    protected void setupRequiredActions(RealmModel realm) {
        if (realm.getRequiredActionProviders().size() == 0) {
            DefaultRequiredActions.addActions((RealmModel)realm);
        }
    }

    protected void setupOfflineTokens(RealmModel realm) {
        KeycloakModelUtils.setupOfflineTokens((RealmModel)realm);
    }

    protected void setupAdminConsole(RealmModel realm) {
        RoleModel adminRole;
        ClientModel adminConsole = realm.getClientByClientId("security-admin-console");
        if (adminConsole == null) {
            adminConsole = KeycloakModelUtils.createClient((RealmModel)realm, (String)"security-admin-console");
        }
        adminConsole.setName("${client_security-admin-console}");
        String baseUrl = this.contextPath + "/admin/" + realm.getName() + "/console";
        adminConsole.setBaseUrl(baseUrl + "/index.html");
        adminConsole.setEnabled(true);
        adminConsole.setPublicClient(true);
        adminConsole.addRedirectUri(baseUrl + "/*");
        adminConsole.setFullScopeAllowed(false);
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRole = realm.getRole(AdminRoles.ADMIN);
        } else {
            String realmAdminApplicationClientId = this.getRealmAdminClientId(realm);
            ClientModel realmAdminApp = realm.getClientByClientId(realmAdminApplicationClientId);
            adminRole = realmAdminApp.getRole(AdminRoles.REALM_ADMIN);
        }
        adminConsole.addScopeMapping(adminRole);
    }

    protected void setupAdminConsoleLocaleMapper(RealmModel realm) {
        ClientModel adminConsole = realm.getClientByClientId("security-admin-console");
        ProtocolMapperModel localeMapper = adminConsole.getProtocolMapperByName("openid-connect", "locale");
        if (localeMapper == null && (localeMapper = ProtocolMapperUtils.findLocaleMapper(this.session)) != null) {
            adminConsole.addProtocolMapper(localeMapper);
        }
    }

    public void setupAdminCli(RealmModel realm) {
        ClientModel adminCli = realm.getClientByClientId("admin-cli");
        if (adminCli == null) {
            RoleModel adminRole;
            adminCli = KeycloakModelUtils.createClient((RealmModel)realm, (String)"admin-cli");
            adminCli.setName("${client_admin-cli}");
            adminCli.setEnabled(true);
            adminCli.setPublicClient(true);
            adminCli.setFullScopeAllowed(false);
            adminCli.setStandardFlowEnabled(false);
            adminCli.setDirectAccessGrantsEnabled(true);
            if (realm.getName().equals(Config.getAdminRealm())) {
                adminRole = realm.getRole(AdminRoles.ADMIN);
            } else {
                String realmAdminApplicationClientId = this.getRealmAdminClientId(realm);
                ClientModel realmAdminApp = realm.getClientByClientId(realmAdminApplicationClientId);
                adminRole = realmAdminApp.getRole(AdminRoles.REALM_ADMIN);
            }
            adminCli.addScopeMapping(adminRole);
        }
    }

    public String getRealmAdminClientId(RealmModel realm) {
        return "realm-management";
    }

    public String getRealmAdminClientId(RealmRepresentation realm) {
        return "realm-management";
    }

    protected void setupRealmDefaults(RealmModel realm) {
        realm.setBrowserSecurityHeaders(BrowserSecurityHeaders.defaultHeaders);
        realm.setBruteForceProtected(false);
        realm.setMaxFailureWaitSeconds(900);
        realm.setMinimumQuickLoginWaitSeconds(60);
        realm.setWaitIncrementSeconds(60);
        realm.setQuickLoginCheckMilliSeconds(1000L);
        realm.setMaxDeltaTimeSeconds(43200);
        realm.setFailureFactor(30);
        realm.setSslRequired(SslRequired.EXTERNAL);
        realm.setOTPPolicy(OTPPolicy.DEFAULT_POLICY);
        realm.setEventsListeners(Collections.singleton("jboss-logging"));
        realm.setPasswordPolicy(new PasswordPolicy("hashIterations(20000)"));
    }

    public boolean removeRealm(RealmModel realm) {
        List federationProviders = realm.getUserFederationProviders();
        ClientModel masterAdminClient = realm.getMasterAdminClient();
        boolean removed = this.model.removeRealm(realm.getId());
        if (removed) {
            UserSessionPersisterProvider sessionsPersister;
            UserSessionProvider sessions;
            if (masterAdminClient != null) {
                new ClientManager(this).removeClient(this.getKeycloakAdminstrationRealm(), masterAdminClient);
            }
            if ((sessions = this.session.sessions()) != null) {
                sessions.onRealmRemoved(realm);
            }
            if ((sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)) != null) {
                sessionsPersister.onRealmRemoved(realm);
            }
            UsersSyncManager usersSyncManager = new UsersSyncManager();
            for (UserFederationProviderModel fedProvider : federationProviders) {
                usersSyncManager.notifyToRefreshPeriodicSync(this.session, realm, fedProvider, true);
            }
        }
        return removed;
    }

    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep, RealmModel realm) {
        realm.setEventsEnabled(rep.isEventsEnabled());
        realm.setEventsExpiration(rep.getEventsExpiration() != null ? rep.getEventsExpiration() : 0L);
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            realm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            realm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
    }

    public void setupMasterAdminManagement(RealmModel realm) {
        String adminRealmId = Config.getAdminRealm();
        RealmModel adminRealm = this.model.getRealm(adminRealmId);
        ClientModel masterApp = adminRealm.getClientByClientId(KeycloakModelUtils.getMasterRealmAdminApplicationClientId((String)realm.getName()));
        if (masterApp != null) {
            realm.setMasterAdminClient(masterApp);
        } else {
            this.createMasterAdminManagement(realm);
        }
    }

    private void createMasterAdminManagement(RealmModel realm) {
        RoleModel adminRole;
        RealmModel adminRealm;
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRealm = realm;
            adminRole = realm.addRole(AdminRoles.ADMIN);
            RoleModel createRealmRole = realm.addRole(AdminRoles.CREATE_REALM);
            adminRole.addCompositeRole(createRealmRole);
            createRealmRole.setDescription("${role_" + AdminRoles.CREATE_REALM + "}");
            createRealmRole.setScopeParamRequired(false);
        } else {
            adminRealm = this.model.getRealm(Config.getAdminRealm());
            adminRole = adminRealm.getRole(AdminRoles.ADMIN);
        }
        adminRole.setDescription("${role_" + AdminRoles.ADMIN + "}");
        adminRole.setScopeParamRequired(false);
        ClientModel realmAdminApp = KeycloakModelUtils.createClient((RealmModel)adminRealm, (String)KeycloakModelUtils.getMasterRealmAdminApplicationClientId((String)realm.getName()));
        realmAdminApp.setName(realm.getName() + " Realm");
        realmAdminApp.setBearerOnly(true);
        realm.setMasterAdminClient(realmAdminApp);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.addRole(r);
            role.setDescription("${role_" + r + "}");
            role.setScopeParamRequired(false);
            adminRole.addCompositeRole(role);
        }
    }

    private void checkMasterAdminManagementRoles(RealmModel realm) {
        RealmModel adminRealm = this.model.getRealmByName(Config.getAdminRealm());
        RoleModel adminRole = adminRealm.getRole(AdminRoles.ADMIN);
        ClientModel masterAdminClient = realm.getMasterAdminClient();
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel found = masterAdminClient.getRole(r);
            if (found != null) continue;
            this.addAndSetAdminRole(r, masterAdminClient, adminRole);
        }
    }

    private void setupRealmAdminManagement(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        String realmAdminClientId = this.getRealmAdminClientId(realm);
        ClientModel realmAdminClient = realm.getClientByClientId(realmAdminClientId);
        if (realmAdminClient == null) {
            realmAdminClient = KeycloakModelUtils.createClient((RealmModel)realm, (String)realmAdminClientId);
            realmAdminClient.setName("${client_" + realmAdminClientId + "}");
        }
        RoleModel adminRole = realmAdminClient.addRole(AdminRoles.REALM_ADMIN);
        adminRole.setDescription("${role_" + AdminRoles.REALM_ADMIN + "}");
        adminRole.setScopeParamRequired(false);
        realmAdminClient.setBearerOnly(true);
        realmAdminClient.setFullScopeAllowed(false);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            this.addAndSetAdminRole(r, realmAdminClient, adminRole);
        }
    }

    private void addAndSetAdminRole(String roleName, ClientModel parentClient, RoleModel parentRole) {
        RoleModel role = parentClient.addRole(roleName);
        role.setDescription("${role_" + roleName + "}");
        role.setScopeParamRequired(false);
        parentRole.addCompositeRole(role);
    }

    private void checkRealmAdminManagementRoles(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        String realmAdminClientId = this.getRealmAdminClientId(realm);
        ClientModel realmAdminClient = realm.getClientByClientId(realmAdminClientId);
        RoleModel adminRole = realmAdminClient.getRole(AdminRoles.REALM_ADMIN);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel found = realmAdminClient.getRole(r);
            if (found != null) continue;
            this.addAndSetAdminRole(r, realmAdminClient, adminRole);
        }
    }

    private void setupAccountManagement(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("account");
        if (client == null) {
            client = KeycloakModelUtils.createClient((RealmModel)realm, (String)"account");
            client.setName("${client_account}");
            client.setEnabled(true);
            client.setFullScopeAllowed(false);
            String base = this.contextPath + "/realms/" + realm.getName() + "/account";
            String redirectUri = base + "/*";
            client.addRedirectUri(redirectUri);
            client.setBaseUrl(base);
            for (String role : AccountRoles.ALL) {
                client.addDefaultRole(role);
                RoleModel roleModel = client.getRole(role);
                roleModel.setDescription("${role_" + role + "}");
                roleModel.setScopeParamRequired(false);
            }
        }
    }

    public void setupImpersonationService(RealmModel realm) {
        ImpersonationConstants.setupImpersonationService((KeycloakSession)this.session, (RealmModel)realm);
    }

    public void setupBrokerService(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("broker");
        if (client == null) {
            client = KeycloakModelUtils.createClient((RealmModel)realm, (String)"broker");
            client.setEnabled(true);
            client.setName("${client_broker}");
            client.setFullScopeAllowed(false);
            for (String role : Constants.BROKER_SERVICE_ROLES) {
                RoleModel roleModel = client.addRole(role);
                roleModel.setDescription("${role_" + role.toLowerCase().replaceAll("_", "-") + "}");
                roleModel.setScopeParamRequired(false);
            }
        }
    }

    public RealmModel importRealm(RealmRepresentation rep) {
        String id = rep.getId();
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.model.createRealm(id, rep.getRealm());
        realm.setName(rep.getRealm());
        this.setupRealmDefaults(realm);
        boolean postponeMasterClientSetup = this.postponeMasterClientSetup(rep);
        if (!postponeMasterClientSetup) {
            this.setupMasterAdminManagement(realm);
        }
        if (!this.hasRealmAdminManagementClient(rep)) {
            this.setupRealmAdminManagement(realm);
        }
        if (!this.hasAccountManagementClient(rep)) {
            this.setupAccountManagement(realm);
        }
        boolean postponeImpersonationSetup = false;
        if (this.hasRealmAdminManagementClient(rep)) {
            postponeImpersonationSetup = true;
        } else {
            this.setupImpersonationService(realm);
        }
        if (!this.hasBrokerClient(rep)) {
            this.setupBrokerService(realm);
        }
        if (!this.hasAdminConsoleClient(rep)) {
            this.setupAdminConsole(realm);
        }
        boolean postponeAdminCliSetup = false;
        if (!this.hasAdminCliClient(rep)) {
            if (this.hasRealmAdminManagementClient(rep)) {
                postponeAdminCliSetup = true;
            } else {
                this.setupAdminCli(realm);
            }
        }
        if (!this.hasRealmRole(rep, "offline_access")) {
            this.setupOfflineTokens(realm);
        }
        RepresentationToModel.importRealm((KeycloakSession)this.session, (RealmRepresentation)rep, (RealmModel)realm);
        this.setupAdminConsoleLocaleMapper(realm);
        if (postponeMasterClientSetup) {
            this.setupMasterAdminManagement(realm);
        }
        this.checkMasterAdminManagementRoles(realm);
        this.checkRealmAdminManagementRoles(realm);
        if (postponeImpersonationSetup) {
            this.setupImpersonationService(realm);
        }
        if (postponeAdminCliSetup) {
            this.setupAdminCli(realm);
        }
        this.setupAuthenticationFlows(realm);
        this.setupRequiredActions(realm);
        List federationProviders = realm.getUserFederationProviders();
        UsersSyncManager usersSyncManager = new UsersSyncManager();
        for (UserFederationProviderModel fedProvider : federationProviders) {
            usersSyncManager.notifyToRefreshPeriodicSync(this.session, realm, fedProvider, false);
        }
        this.setupAuthorizationServices(realm);
        return realm;
    }

    private boolean postponeMasterClientSetup(RealmRepresentation rep) {
        if (!Config.getAdminRealm().equals(rep.getRealm())) {
            return false;
        }
        return this.hasRealmAdminManagementClient(rep);
    }

    private boolean hasRealmAdminManagementClient(RealmRepresentation rep) {
        String realmAdminClientId = Config.getAdminRealm().equals(rep.getRealm()) ? KeycloakModelUtils.getMasterRealmAdminApplicationClientId((String)rep.getRealm()) : this.getRealmAdminClientId(rep);
        return this.hasClient(rep, realmAdminClientId);
    }

    private boolean hasAccountManagementClient(RealmRepresentation rep) {
        return this.hasClient(rep, "account");
    }

    private boolean hasBrokerClient(RealmRepresentation rep) {
        return this.hasClient(rep, "broker");
    }

    private boolean hasAdminConsoleClient(RealmRepresentation rep) {
        return this.hasClient(rep, "security-admin-console");
    }

    private boolean hasAdminCliClient(RealmRepresentation rep) {
        return this.hasClient(rep, "admin-cli");
    }

    private boolean hasClient(RealmRepresentation rep, String clientId) {
        if (rep.getClients() != null) {
            for (ClientRepresentation clientRep : rep.getClients()) {
                if (clientRep.getClientId() == null || !clientRep.getClientId().equals(clientId)) continue;
                return true;
            }
        }
        if (rep.getApplications() != null) {
            for (ClientRepresentation clientRep : rep.getApplications()) {
                if (!clientRep.getName().equals(clientId)) continue;
                return true;
            }
        }
        if (rep.getOauthClients() != null) {
            for (ClientRepresentation clientRep : rep.getOauthClients()) {
                if (!clientRep.getName().equals(clientId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRealmRole(RealmRepresentation rep, String roleName) {
        if (rep.getRoles() == null || rep.getRoles().getRealm() == null) {
            return false;
        }
        for (RoleRepresentation role : rep.getRoles().getRealm()) {
            if (!roleName.equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    public List<UserModel> searchUsers(String searchString, RealmModel realmModel) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        return this.session.users().searchForUser(searchString.trim(), realmModel);
    }

    private void setupAuthorizationServices(RealmModel realm) {
        for (String roleName : Constants.AUTHZ_DEFAULT_AUTHORIZATION_ROLES) {
            if (realm.getRole(roleName) != null) continue;
            RoleModel role = realm.addRole(roleName);
            role.setDescription("${role_" + roleName + "}");
            role.setScopeParamRequired(false);
            realm.addDefaultRole(roleName);
        }
    }
}

