/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;

public class DefaultPolicyEvaluator
implements PolicyEvaluator {
    private final AuthorizationProvider authorization;
    private Map<String, PolicyProviderFactory> policyProviders = new HashMap<String, PolicyProviderFactory>();

    public DefaultPolicyEvaluator(AuthorizationProvider authorization, List<PolicyProviderFactory> policyProviderFactories) {
        this.authorization = authorization;
        for (PolicyProviderFactory providerFactory : policyProviderFactories) {
            this.policyProviders.put(providerFactory.getId(), providerFactory);
        }
    }

    @Override
    public void evaluate(ResourcePermission permission, EvaluationContext executionContext, Decision decision) {
        ResourceServer resourceServer = permission.getResourceServer();
        if (ResourceServer.PolicyEnforcementMode.DISABLED.equals((Object)resourceServer.getPolicyEnforcementMode())) {
            this.createEvaluation(permission, executionContext, decision, null, null).grant();
            return;
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        AtomicInteger policiesCount = new AtomicInteger(0);
        Consumer<Policy> consumer = this.createDecisionConsumer(permission, executionContext, decision, policiesCount);
        Resource resource = permission.getResource();
        if (resource != null) {
            List<Policy> resourcePolicies = policyStore.findByResource(resource.getId());
            if (!resourcePolicies.isEmpty()) {
                resourcePolicies.forEach(consumer);
            }
            if (resource.getType() != null) {
                policyStore.findByResourceType(resource.getType(), resourceServer.getId()).forEach(consumer);
            }
            if (permission.getScopes().isEmpty() && !resource.getScopes().isEmpty()) {
                policyStore.findByScopeIds(resource.getScopes().stream().map(Scope::getId).collect(Collectors.toList()), resourceServer.getId()).forEach(consumer);
            }
        }
        if (!permission.getScopes().isEmpty()) {
            policyStore.findByScopeIds(permission.getScopes().stream().map(Scope::getId).collect(Collectors.toList()), resourceServer.getId()).forEach(consumer);
        }
        if (ResourceServer.PolicyEnforcementMode.PERMISSIVE.equals((Object)resourceServer.getPolicyEnforcementMode()) && policiesCount.get() == 0) {
            this.createEvaluation(permission, executionContext, decision, null, null).grant();
        }
    }

    private Consumer<Policy> createDecisionConsumer(ResourcePermission permission, EvaluationContext executionContext, Decision decision, AtomicInteger policiesCount) {
        return parentPolicy -> {
            if (this.hasRequestedScopes(permission, (Policy)parentPolicy)) {
                for (Policy associatedPolicy : parentPolicy.getAssociatedPolicies()) {
                    PolicyProviderFactory providerFactory = this.policyProviders.get(associatedPolicy.getType());
                    if (providerFactory == null) {
                        throw new RuntimeException("Could not find a policy provider for policy type [" + associatedPolicy.getType() + "].");
                    }
                    PolicyProvider policyProvider = providerFactory.create(associatedPolicy, this.authorization);
                    if (policyProvider == null) {
                        throw new RuntimeException("Unknown parentPolicy provider for type [" + associatedPolicy.getType() + "].");
                    }
                    DefaultEvaluation evaluation = this.createEvaluation(permission, executionContext, decision, (Policy)parentPolicy, associatedPolicy);
                    policyProvider.evaluate(evaluation);
                    evaluation.denyIfNoEffect();
                    policiesCount.incrementAndGet();
                }
            }
        };
    }

    private DefaultEvaluation createEvaluation(ResourcePermission permission, EvaluationContext executionContext, Decision decision, Policy parentPolicy, Policy associatedPolicy) {
        return new DefaultEvaluation(permission, executionContext, parentPolicy, associatedPolicy, decision);
    }

    private boolean hasRequestedScopes(ResourcePermission permission, Policy policy) {
        if (permission.getScopes().isEmpty()) {
            return true;
        }
        if (policy.getScopes().isEmpty()) {
            return true;
        }
        boolean hasScope = true;
        for (Scope givenScope : policy.getScopes()) {
            boolean hasGivenScope = false;
            for (Scope scope : permission.getScopes()) {
                if (!givenScope.getId().equals(scope.getId())) continue;
                hasGivenScope = true;
                break;
            }
            if (hasGivenScope) continue;
            return false;
        }
        return hasScope;
    }
}

