/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Collections;
import java.util.HashMap;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class MigrateTo1_9_2 {
    public static final ModelVersion VERSION = new ModelVersion("1.9.2");

    public void migrate(KeycloakSession session) {
        for (RealmModel realm : session.realms().getRealms()) {
            if (realm.getBrowserSecurityHeaders() == null) continue;
            HashMap<String, String> browserSecurityHeaders = new HashMap<String, String>(realm.getBrowserSecurityHeaders());
            browserSecurityHeaders.put("xContentTypeOptions", "nosniff");
            realm.setBrowserSecurityHeaders(Collections.unmodifiableMap(browserSecurityHeaders));
        }
    }
}

