/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAScopeStore
implements ScopeStore {
    private final EntityManager entityManager;

    public JPAScopeStore(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Scope create(String name, ResourceServer resourceServer) {
        ScopeEntity entity = new ScopeEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setResourceServer((ResourceServerEntity)resourceServer);
        this.entityManager.persist((Object)entity);
        return entity;
    }

    public void delete(String id) {
        this.entityManager.remove((Object)this.findById(id));
    }

    public Scope findById(String id) {
        return (Scope)this.entityManager.find(ScopeEntity.class, (Object)id);
    }

    public Scope findByName(String name, String resourceServerId) {
        try {
            Query query = this.entityManager.createQuery("select s from ScopeEntity s inner join s.resourceServer rs where rs.id = :resourceServerId and name = :name");
            query.setParameter("name", (Object)name);
            query.setParameter("resourceServerId", (Object)resourceServerId);
            return (Scope)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<Scope> findByResourceServer(String serverId) {
        Query query = this.entityManager.createQuery("from ScopeEntity where resourceServer.id = :serverId");
        query.setParameter("serverId", (Object)serverId);
        return query.getResultList();
    }
}

