/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.InjectedNetworkBindingStreamServerService;
import org.jboss.as.remoting.InjectedSocketBindingStreamServerService;
import org.jboss.as.remoting.RealmSecurityProviderService;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public class RemotingServices {
    public static final ServiceName REMOTING_BASE = ServiceName.JBOSS.append(new String[]{"remoting"});
    public static final ServiceName SUBSYSTEM_ENDPOINT = RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY.getCapabilityServiceName(Endpoint.class);
    private static final ServiceName CONNECTOR_BASE = REMOTING_BASE.append(new String[]{"connector"});
    private static final ServiceName SERVER_BASE = REMOTING_BASE.append(new String[]{"server"});

    public static ServiceName connectorServiceName(String connectorName) {
        return CONNECTOR_BASE.append(new String[]{connectorName});
    }

    public static ServiceName serverServiceName(String connectorName) {
        return SERVER_BASE.append(new String[]{connectorName});
    }

    public static ServiceName channelServiceName(ServiceName endpointName, String channelName) {
        return endpointName.append(new String[]{"channel"}).append(new String[]{channelName});
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type) {
        RemotingServices.installRemotingManagementEndpoint(serviceTarget, endpointName, hostName, type, OptionMap.EMPTY);
    }

    public static void installRemotingManagementEndpoint(ServiceTarget serviceTarget, ServiceName endpointName, String hostName, EndpointService.EndpointType type, OptionMap options) {
        EndpointService service = new EndpointService(hostName, type, options);
        serviceTarget.addService(endpointName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ServiceName.JBOSS.append(new String[]{"serverManagement", "controller", "management", "worker"}), XnioWorker.class, service.getWorker()).install();
    }

    @Deprecated
    public static void installConnectorServicesForNetworkInterfaceBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName networkInterfaceBindingName, int port, OptionMap connectorPropertiesOptionMap) {
        RemotingServices.installConnectorServices(serviceTarget, endpointName, connectorName, networkInterfaceBindingName, port, true, connectorPropertiesOptionMap);
    }

    public static void installConnectorServicesForSocketBinding(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName socketBindingName, OptionMap connectorPropertiesOptionMap) {
        RemotingServices.installConnectorServices(serviceTarget, endpointName, connectorName, socketBindingName, 0, false, connectorPropertiesOptionMap);
    }

    public static void installSecurityServices(ServiceTarget serviceTarget, String connectorName, String realmName, ServiceName serverCallbackServiceName, ServiceName tmpDirService) {
        ServiceName securityProviderName = RealmSecurityProviderService.createName(connectorName);
        RealmSecurityProviderService rsps = new RealmSecurityProviderService();
        ServiceBuilder builder = serviceTarget.addService(securityProviderName, (Service)rsps);
        if (realmName != null) {
            SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)builder, rsps.getSecurityRealmInjectedValue(), (String)realmName, (boolean)false);
        }
        if (serverCallbackServiceName != null) {
            builder.addDependency(serverCallbackServiceName, CallbackHandler.class, rsps.getServerCallbackValue());
        }
        builder.addDependency(tmpDirService, String.class, rsps.getTmpDirValue());
        builder.install();
    }

    private static void installConnectorServices(ServiceTarget serviceTarget, ServiceName endpointName, String connectorName, ServiceName bindingName, int port, boolean isNetworkInterfaceBinding, OptionMap connectorPropertiesOptionMap) {
        ServiceName securityProviderName = RealmSecurityProviderService.createName(connectorName);
        if (isNetworkInterfaceBinding) {
            InjectedNetworkBindingStreamServerService streamServerService = new InjectedNetworkBindingStreamServerService(connectorPropertiesOptionMap, port);
            serviceTarget.addService(RemotingServices.serverServiceName(connectorName), (Service)streamServerService).addDependency(securityProviderName, RemotingSecurityProvider.class, streamServerService.getSecurityProviderInjector()).addDependency(endpointName, Endpoint.class, streamServerService.getEndpointInjector()).addDependency(bindingName, NetworkInterfaceBinding.class, streamServerService.getInterfaceBindingInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, streamServerService.getSocketBindingManagerInjector()).install();
        } else {
            InjectedSocketBindingStreamServerService streamServerService = new InjectedSocketBindingStreamServerService(connectorPropertiesOptionMap);
            serviceTarget.addService(RemotingServices.serverServiceName(connectorName), (Service)streamServerService).addDependency(securityProviderName, RemotingSecurityProvider.class, streamServerService.getSecurityProviderInjector()).addDependency(endpointName, Endpoint.class, streamServerService.getEndpointInjector()).addDependency(bindingName, SocketBinding.class, streamServerService.getSocketBindingInjector()).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, streamServerService.getSocketBindingManagerInjector()).install();
        }
    }

    public static void removeConnectorServices(OperationContext context, String connectorName) {
        ServiceName securityProviderName = RealmSecurityProviderService.createName(connectorName);
        context.removeService(RemotingServices.serverServiceName(connectorName));
        context.removeService(securityProviderName);
    }
}

