/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Self;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.logging.Log;

public abstract class TableManipulationConfigurationBuilder<B extends AbstractJdbcStoreConfigurationBuilder<?, B>, S extends TableManipulationConfigurationBuilder<B, S>>
extends AbstractJdbcStoreConfigurationChildBuilder<B>
implements Builder<TableManipulationConfiguration>,
Self<S> {
    private static final Log log = (Log)LogFactory.getLog(TableManipulationConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = TableManipulationConfiguration.attributeSet();

    TableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, B> builder) {
        super(builder);
    }

    public S batchSize(int batchSize) {
        this.attributes.attribute(TableManipulationConfiguration.BATCH_SIZE).set((Object)batchSize);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S fetchSize(int fetchSize) {
        this.attributes.attribute(TableManipulationConfiguration.FETCH_SIZE).set((Object)fetchSize);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S tableNamePrefix(String tableNamePrefix) {
        this.attributes.attribute(TableManipulationConfiguration.TABLE_NAME_PREFIX).set((Object)tableNamePrefix);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    String tableNamePrefix() {
        return (String)this.attributes.attribute(TableManipulationConfiguration.TABLE_NAME_PREFIX).get();
    }

    public S createOnStart(boolean createOnStart) {
        this.attributes.attribute(TableManipulationConfiguration.CREATE_ON_START).set((Object)createOnStart);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dropOnExit(boolean dropOnExit) {
        this.attributes.attribute(TableManipulationConfiguration.DROP_ON_EXIT).set((Object)dropOnExit);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S idColumnName(String idColumnName) {
        this.attributes.attribute(TableManipulationConfiguration.ID_COLUMN_NAME).set((Object)idColumnName);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S idColumnType(String idColumnType) {
        this.attributes.attribute(TableManipulationConfiguration.ID_COLUMN_TYPE).set((Object)idColumnType);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dataColumnName(String dataColumnName) {
        this.attributes.attribute(TableManipulationConfiguration.DATA_COLUMN_NAME).set((Object)dataColumnName);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S dataColumnType(String dataColumnType) {
        this.attributes.attribute(TableManipulationConfiguration.DATA_COLUMN_TYPE).set((Object)dataColumnType);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S timestampColumnName(String timestampColumnName) {
        this.attributes.attribute(TableManipulationConfiguration.TIMESTAMP_COLUMN_NAME).set((Object)timestampColumnName);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public S timestampColumnType(String timestampColumnType) {
        this.attributes.attribute(TableManipulationConfiguration.TIMESTAMP_COLUMN_TYPE).set((Object)timestampColumnType);
        return (S)((TableManipulationConfigurationBuilder)this.self());
    }

    public void validate() {
        this.validateIfSet(TableManipulationConfiguration.ID_COLUMN_NAME, TableManipulationConfiguration.ID_COLUMN_TYPE, TableManipulationConfiguration.DATA_COLUMN_NAME, TableManipulationConfiguration.DATA_COLUMN_TYPE, TableManipulationConfiguration.TIMESTAMP_COLUMN_NAME, TableManipulationConfiguration.TIMESTAMP_COLUMN_TYPE, TableManipulationConfiguration.TABLE_NAME_PREFIX);
    }

    private void validateIfSet(AttributeDefinition<?> ... definitions) {
        for (AttributeDefinition<?> definition : definitions) {
            String value = (String)this.attributes.attribute(definition).asObject();
            if (value != null && !value.isEmpty()) continue;
            throw log.tableManipulationAttributeNotSet(definition.name());
        }
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    AttributeSet attributes() {
        return this.attributes;
    }

    public TableManipulationConfiguration create() {
        return new TableManipulationConfiguration(this.attributes.protect());
    }

    public Builder<?> read(TableManipulationConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "TableManipulationConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

