/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.RSAPublicJWK;

public class JWKBuilder {
    public static final String DEFAULT_PUBLIC_KEY_USE = "sig";
    public static final String DEFAULT_MESSAGE_DIGEST = "SHA-256";

    private JWKBuilder() {
    }

    public static JWKBuilder create() {
        return new JWKBuilder();
    }

    public JWK rs256(PublicKey key) {
        RSAPublicKey rsaKey = (RSAPublicKey)key;
        RSAPublicJWK k = new RSAPublicJWK();
        k.setKeyId(this.createKeyId(key));
        k.setKeyType("RSA");
        k.setAlgorithm("RS256");
        k.setPublicKeyUse(DEFAULT_PUBLIC_KEY_USE);
        k.setModulus(Base64Url.encode((byte[])JWKBuilder.toIntegerBytes(rsaKey.getModulus())));
        k.setPublicExponent(Base64Url.encode((byte[])JWKBuilder.toIntegerBytes(rsaKey.getPublicExponent())));
        return k;
    }

    private String createKeyId(Key key) {
        try {
            return Base64Url.encode((byte[])MessageDigest.getInstance(DEFAULT_MESSAGE_DIGEST).digest(key.getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toIntegerBytes(BigInteger bigInt) {
        int bitlen = bigInt.bitLength();
        bitlen = bitlen + 7 >> 3 << 3;
        byte[] bigBytes = bigInt.toByteArray();
        if (bigInt.bitLength() % 8 != 0 && bigInt.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int len = bigBytes.length;
        if (bigInt.bitLength() % 8 == 0) {
            startSrc = 1;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, len);
        return resizedBytes;
    }
}

