/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerConfigurationPersister;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;

public abstract class LocalDomainControllerAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "write-local-domain-controller";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("write-local-domain-controller", HostResolver.getResolver("host")).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.DOMAIN_CONTROLLER).build();

    public static LocalDomainControllerAddHandler getInstance(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, HostFileRepository fileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
        return new RealLocalDomainControllerAddHandler(rootRegistration, hostControllerInfo, overallConfigPersister, fileRepository, contentRepository, domainController, extensionRegistry, pathManager);
    }

    public static LocalDomainControllerAddHandler getTestInstance() {
        return new TestLocalDomainControllerAddHandler();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode dc = model.get("domain-controller");
        dc.get("local").setEmptyObject();
        if (dc.has("remote")) {
            dc.remove("remote");
        }
        if (context.isBooting()) {
            this.initializeDomain();
        } else {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (!context.isBooting()) {
                    context.revertReloadRequired();
                }
            }
        });
    }

    protected abstract void initializeDomain();

    private static class TestLocalDomainControllerAddHandler
    extends LocalDomainControllerAddHandler {
        private TestLocalDomainControllerAddHandler() {
        }

        @Override
        protected void initializeDomain() {
        }
    }

    private static class RealLocalDomainControllerAddHandler
    extends LocalDomainControllerAddHandler {
        private final ManagementResourceRegistration rootRegistration;
        private final HostControllerConfigurationPersister overallConfigPersister;
        private final HostFileRepository fileRepository;
        private final LocalHostControllerInfoImpl hostControllerInfo;
        private final ContentRepository contentRepository;
        private final DomainController domainController;
        private final ExtensionRegistry extensionRegistry;
        private final PathManagerService pathManager;

        protected RealLocalDomainControllerAddHandler(ManagementResourceRegistration rootRegistration, LocalHostControllerInfoImpl hostControllerInfo, HostControllerConfigurationPersister overallConfigPersister, HostFileRepository fileRepository, ContentRepository contentRepository, DomainController domainController, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
            this.rootRegistration = rootRegistration;
            this.overallConfigPersister = overallConfigPersister;
            this.fileRepository = fileRepository;
            this.hostControllerInfo = hostControllerInfo;
            this.contentRepository = contentRepository;
            this.domainController = domainController;
            this.extensionRegistry = extensionRegistry;
            this.pathManager = pathManager;
        }

        @Override
        protected void initializeDomain() {
            this.hostControllerInfo.setMasterDomainController(true);
            this.overallConfigPersister.initializeDomainConfigurationPersister(false);
            this.domainController.initializeMasterDomainRegistry(this.rootRegistration, this.overallConfigPersister.getDomainPersister(), this.contentRepository, this.fileRepository, this.extensionRegistry, this.pathManager);
        }
    }
}

