/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers.membership;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.idm.model.LDAPDn;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.federation.ldap.mappers.membership.CommonLDAPGroupMapper;

public interface UserRolesRetrieveStrategy {
    public List<LDAPObject> getLDAPRoleMappings(CommonLDAPGroupMapper var1, LDAPObject var2);

    public void beforeUserLDAPQuery(LDAPQuery var1);

    public static class LoadRolesByMemberRecursively
    extends LoadRolesByMember {
        @Override
        protected Condition getMembershipCondition(String membershipAttr, String userMembership) {
            return new LDAPQueryConditionsBuilder().equal(membershipAttr + ":1.2.840.113556.1.4.1941:", userMembership);
        }
    }

    public static class GetRolesFromUserMemberOfAttribute
    implements UserRolesRetrieveStrategy {
        @Override
        public List<LDAPObject> getLDAPRoleMappings(CommonLDAPGroupMapper roleOrGroupMapper, LDAPObject ldapUser) {
            Set<String> memberOfValues = ldapUser.getAttributeAsSet("memberOf");
            if (memberOfValues == null) {
                return Collections.emptyList();
            }
            LinkedList<LDAPObject> roles = new LinkedList<LDAPObject>();
            LDAPDn parentDn = LDAPDn.fromString(roleOrGroupMapper.getConfig().getLDAPGroupsDn());
            for (String roleDn : memberOfValues) {
                LDAPDn roleDN = LDAPDn.fromString(roleDn);
                if (!roleDN.isDescendantOf(parentDn)) continue;
                LDAPObject role = new LDAPObject();
                role.setDn(roleDN);
                String firstDN = roleDN.getFirstRdnAttrName();
                if (!firstDN.equalsIgnoreCase(roleOrGroupMapper.getConfig().getLDAPGroupNameLdapAttribute())) continue;
                role.setRdnAttributeName(firstDN);
                role.setSingleAttribute(firstDN, roleDN.getFirstRdnAttrValue());
                roles.add(role);
            }
            return roles;
        }

        @Override
        public void beforeUserLDAPQuery(LDAPQuery query) {
            query.addReturningLdapAttribute("memberOf");
            query.addReturningReadOnlyLdapAttribute("memberOf");
        }
    }

    public static class LoadRolesByMember
    implements UserRolesRetrieveStrategy {
        @Override
        public List<LDAPObject> getLDAPRoleMappings(CommonLDAPGroupMapper roleOrGroupMapper, LDAPObject ldapUser) {
            LDAPQuery ldapQuery = roleOrGroupMapper.createLDAPGroupQuery();
            String membershipAttr = roleOrGroupMapper.getConfig().getMembershipLdapAttribute();
            String userMembership = LDAPUtils.getMemberValueOfChildObject(ldapUser, roleOrGroupMapper.getConfig().getMembershipTypeLdapAttribute());
            Condition membershipCondition = this.getMembershipCondition(membershipAttr, userMembership);
            ldapQuery.addWhereCondition(membershipCondition);
            return ldapQuery.getResultList();
        }

        @Override
        public void beforeUserLDAPQuery(LDAPQuery query) {
        }

        protected Condition getMembershipCondition(String membershipAttr, String userMembership) {
            return new LDAPQueryConditionsBuilder().equal(membershipAttr, userMembership);
        }
    }
}

