/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.time;

import java.text.SimpleDateFormat;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.time.TimePolicyProvider;

public class TimePolicyAdminResource
implements PolicyProviderAdminService {
    public void onCreate(Policy policy) {
        this.validateConfig(policy);
    }

    private void validateConfig(Policy policy) {
        String nbf = (String)policy.getConfig().get("nbf");
        String noa = (String)policy.getConfig().get("noa");
        if (nbf == null && noa == null) {
            throw new RuntimeException("You must provide NotBefore, NotOnOrAfter or both.");
        }
        this.validateFormat(nbf);
        this.validateFormat(noa);
    }

    public void onUpdate(Policy policy) {
        this.validateConfig(policy);
    }

    public void onRemove(Policy policy) {
    }

    private void validateFormat(String date) {
        try {
            new SimpleDateFormat(TimePolicyProvider.DEFAULT_DATE_PATTERN).parse(TimePolicyProvider.format(date));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse a date using format [" + date + "]");
        }
    }
}

