/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import org.wildfly.clustering.service.concurrent.ServiceExecutor;

public class StampedLockServiceExecutor
implements ServiceExecutor {
    private final StampedLock lock = new StampedLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable executeTask) {
        long stamp = this.lock.tryReadLock();
        if (stamp != 0L) {
            try {
                executeTask.run();
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
    }

    @Override
    public void close(Runnable closeTask) {
        if (this.closed.compareAndSet(false, true)) {
            this.lock.writeLock();
            closeTask.run();
        }
    }
}

